/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate;

import io.dropwizard.hibernate.UnitOfWork;
import io.dropwizard.hibernate.UnitOfWorkAspect;
import jakarta.ws.rs.ext.Provider;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.hibernate.SessionFactory;

@Provider
public class UnitOfWorkApplicationListener
implements ApplicationEventListener {
    private final ConcurrentMap<ResourceMethod, Collection<UnitOfWork>> methodMap = new ConcurrentHashMap<ResourceMethod, Collection<UnitOfWork>>();
    private final Map<String, SessionFactory> sessionFactories = new HashMap<String, SessionFactory>();

    public UnitOfWorkApplicationListener() {
    }

    public UnitOfWorkApplicationListener(String name, SessionFactory sessionFactory) {
        this.registerSessionFactory(name, sessionFactory);
    }

    public void registerSessionFactory(String name, SessionFactory sessionFactory) {
        this.sessionFactories.put(name, sessionFactory);
    }

    public void onEvent(ApplicationEvent event) {
    }

    public RequestEventListener onRequest(RequestEvent event) {
        return new UnitOfWorkEventListener(this.methodMap, this.sessionFactories);
    }

    private static class UnitOfWorkEventListener
    implements RequestEventListener {
        private final ConcurrentMap<ResourceMethod, Collection<UnitOfWork>> methodMap;
        private final ConcurrentMap<String, UnitOfWorkAspect> unitOfWorkAspects = new ConcurrentHashMap<String, UnitOfWorkAspect>();
        private final Map<String, SessionFactory> sessionFactories;

        UnitOfWorkEventListener(ConcurrentMap<ResourceMethod, Collection<UnitOfWork>> methodMap, Map<String, SessionFactory> sessionFactories) {
            this.methodMap = methodMap;
            this.sessionFactories = sessionFactories;
        }

        public void onEvent(RequestEvent event) {
            RequestEvent.Type eventType = event.getType();
            if (eventType == RequestEvent.Type.RESOURCE_METHOD_START) {
                try {
                    this.methodMap.computeIfAbsent(event.getUriInfo().getMatchedResourceMethod(), UnitOfWorkEventListener::registerUnitOfWorkAnnotations).forEach(unitOfWork -> this.unitOfWorkAspects.computeIfAbsent(unitOfWork.value(), hibernateName -> new UnitOfWorkAspect(this.sessionFactories)).beforeStart((UnitOfWork)unitOfWork));
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MappableException((Throwable)e);
                }
            } else if (eventType == RequestEvent.Type.RESP_FILTERS_START) {
                try {
                    this.unitOfWorkAspects.values().forEach(UnitOfWorkAspect::afterEnd);
                }
                catch (Exception e) {
                    throw new MappableException((Throwable)e);
                }
            } else if (eventType == RequestEvent.Type.ON_EXCEPTION) {
                this.unitOfWorkAspects.values().forEach(UnitOfWorkAspect::onError);
            } else if (eventType == RequestEvent.Type.FINISHED) {
                this.unitOfWorkAspects.values().forEach(UnitOfWorkAspect::onFinish);
            }
        }

        private static Collection<UnitOfWork> registerUnitOfWorkAnnotations(ResourceMethod method) {
            HashMap unitOfWorkMap = new HashMap();
            Arrays.stream((UnitOfWork[])method.getInvocable().getHandlingMethod().getAnnotationsByType(UnitOfWork.class)).forEach(unitOfWork -> unitOfWorkMap.put(unitOfWork.value(), unitOfWork));
            Arrays.stream((UnitOfWork[])method.getInvocable().getDefinitionMethod().getAnnotationsByType(UnitOfWork.class)).forEach(unitOfWork -> unitOfWorkMap.put(unitOfWork.value(), unitOfWork));
            return unitOfWorkMap.values();
        }
    }
}

