/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.hibernate.dual;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.metamodel.Metamodel;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.stat.Statistics;

public class DualSessionFactory
implements SessionFactory {
    private static final long serialVersionUID = 1L;
    private final SessionFactory primary;
    private final SessionFactory reader;
    private final ThreadLocal<SessionFactory> current = new ThreadLocal();

    public DualSessionFactory(SessionFactory primary, SessionFactory reader) {
        this.primary = primary;
        this.reader = reader;
        this.current.set(primary);
    }

    public SessionFactory prepare(boolean readOnly) {
        SessionFactory factory = readOnly ? this.reader : this.primary;
        this.current.set(factory);
        return factory;
    }

    public SessionFactory current() {
        return this.current.get();
    }

    public EntityManager createEntityManager() {
        return this.current().createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.current().createEntityManager(map);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return this.current().createEntityManager(synchronizationType);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return this.current().createEntityManager(synchronizationType, map);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.current().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.current().getMetamodel();
    }

    public boolean isOpen() {
        return this.current().isOpen();
    }

    public Map<String, Object> getProperties() {
        return this.current().getProperties();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.current().getPersistenceUnitUtil();
    }

    public void addNamedQuery(String name, Query query) {
        this.current().addNamedQuery(name, query);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.current().unwrap(cls);
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.current().addNamedEntityGraph(graphName, entityGraph);
    }

    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        return this.current().findEntityGraphsByType(entityClass);
    }

    public Reference getReference() throws NamingException {
        return this.current().getReference();
    }

    public SessionFactoryOptions getSessionFactoryOptions() {
        return this.current().getSessionFactoryOptions();
    }

    public SessionBuilder withOptions() {
        return this.current().withOptions();
    }

    public Session openSession() throws HibernateException {
        return this.current().openSession();
    }

    public Session getCurrentSession() throws HibernateException {
        return this.current().getCurrentSession();
    }

    public StatelessSessionBuilder withStatelessOptions() {
        return this.current().withStatelessOptions();
    }

    public StatelessSession openStatelessSession() {
        return this.current().openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return this.current().openStatelessSession(connection);
    }

    public void inSession(Consumer<Session> action) {
        this.current().inSession(action);
    }

    public void inTransaction(Consumer<Session> action) {
        this.current().inTransaction(action);
    }

    public <R> R fromSession(Function<Session, R> action) {
        return (R)this.current().fromSession(action);
    }

    public <R> R fromTransaction(Function<Session, R> action) {
        return (R)this.current().fromTransaction(action);
    }

    public Statistics getStatistics() {
        return this.current().getStatistics();
    }

    public void close() throws HibernateException {
        this.current().close();
    }

    public boolean isClosed() {
        return this.current().isClosed();
    }

    public Cache getCache() {
        return this.current().getCache();
    }

    public Set getDefinedFilterNames() {
        return this.current().getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.current().getFilterDefinition(filterName);
    }

    public boolean containsFetchProfileDefinition(String name) {
        return this.current().containsFetchProfileDefinition(name);
    }
}

