/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.http2;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.jetty.Jetty93InstrumentedConnectionFactory;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

@JsonTypeName(value="h2c")
public class Http2CConnectorFactory
extends HttpConnectorFactory {
    @Min(value=100L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=100L) @Max(value=0x7FFFFFFFL) int maxConcurrentStreams = 1024;
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @Max(value=0x7FFFFFFFL) int initialStreamRecvWindow = 65535;

    @JsonProperty
    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    @JsonProperty
    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    @JsonProperty
    public int getInitialStreamRecvWindow() {
        return this.initialStreamRecvWindow;
    }

    @JsonProperty
    public void setInitialStreamRecvWindow(int initialStreamRecvWindow) {
        this.initialStreamRecvWindow = initialStreamRecvWindow;
    }

    public Connector build(Server server, MetricRegistry metrics, String name, @Nullable ThreadPool threadPool) {
        HttpConfiguration httpConfig = this.buildHttpConfiguration();
        HttpConnectionFactory http11 = this.buildHttpConnectionFactory(httpConfig);
        HTTP2CServerConnectionFactory http2c = new HTTP2CServerConnectionFactory(httpConfig);
        http2c.setMaxConcurrentStreams(this.maxConcurrentStreams);
        http2c.setInitialStreamRecvWindow(this.initialStreamRecvWindow);
        return this.buildConnector(server, (Scheduler)new ScheduledExecutorScheduler(), this.buildBufferPool(), name, threadPool, new ConnectionFactory[]{new Jetty93InstrumentedConnectionFactory((ConnectionFactory)http11, metrics.timer(this.httpConnections())), http2c});
    }
}

