/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk7.Jdk7Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import io.dropwizard.jackson.AnnotationSensitivePropertyNamingStrategy;
import io.dropwizard.jackson.DiscoverableSubtypeResolver;
import io.dropwizard.jackson.FuzzyEnumModule;
import io.dropwizard.jackson.GuavaExtrasModule;
import io.dropwizard.jackson.LogbackModule;

public class Jackson {
    private Jackson() {
    }

    public static ObjectMapper newObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        return Jackson.configure(mapper);
    }

    public static ObjectMapper newObjectMapper(JsonFactory jsonFactory) {
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        return Jackson.configure(mapper);
    }

    public static ObjectMapper newMinimalObjectMapper() {
        return new ObjectMapper().registerModule((Module)new GuavaModule()).registerModule((Module)new LogbackModule()).setSubtypeResolver((SubtypeResolver)new DiscoverableSubtypeResolver());
    }

    private static ObjectMapper configure(ObjectMapper mapper) {
        mapper.registerModule((Module)new GuavaModule());
        mapper.registerModule((Module)new LogbackModule());
        mapper.registerModule((Module)new GuavaExtrasModule());
        mapper.registerModule((Module)new JodaModule());
        mapper.registerModule((Module)new AfterburnerModule());
        mapper.registerModule((Module)new FuzzyEnumModule());
        mapper.registerModule((Module)new Jdk7Module());
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new AnnotationSensitivePropertyNamingStrategy());
        mapper.setSubtypeResolver((SubtypeResolver)new DiscoverableSubtypeResolver());
        return mapper;
    }
}

