/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.jdbi.InstrumentedTimingCollector;
import com.codahale.metrics.jdbi.strategies.DelegatingStatementNameStrategy;
import com.codahale.metrics.jdbi.strategies.NameStrategies;
import com.codahale.metrics.jdbi.strategies.StatementNameStrategy;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.jdbi.DBIHealthCheck;
import io.dropwizard.jdbi.ImmutableListContainerFactory;
import io.dropwizard.jdbi.ImmutableSetContainerFactory;
import io.dropwizard.jdbi.NamePrependingStatementRewriter;
import io.dropwizard.jdbi.OptionalContainerFactory;
import io.dropwizard.jdbi.args.JodaDateTimeArgumentFactory;
import io.dropwizard.jdbi.args.JodaDateTimeMapper;
import io.dropwizard.jdbi.args.OptionalArgumentFactory;
import io.dropwizard.jdbi.logging.LogbackLog;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import javax.sql.DataSource;
import org.skife.jdbi.v2.ColonPrefixNamedParamStatementRewriter;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.ContainerFactory;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.StatementRewriter;
import org.slf4j.LoggerFactory;

public class DBIFactory {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(DBI.class);
    private static final String RAW_SQL = MetricRegistry.name(DBI.class, (String[])new String[]{"raw-sql"});

    public DBI build(Environment environment, DataSourceFactory configuration, String name) throws ClassNotFoundException {
        ManagedDataSource dataSource = configuration.build(environment.metrics(), name);
        return this.build(environment, configuration, dataSource, name);
    }

    public DBI build(Environment environment, DataSourceFactory configuration, ManagedDataSource dataSource, String name) {
        String validationQuery = configuration.getValidationQuery();
        DBI dbi = new DBI((DataSource)dataSource);
        environment.lifecycle().manage((Managed)dataSource);
        environment.healthChecks().register(name, (HealthCheck)new DBIHealthCheck(dbi, validationQuery));
        dbi.setSQLLog((SQLLog)new LogbackLog(LOGGER, Level.TRACE));
        dbi.setTimingCollector((TimingCollector)new InstrumentedTimingCollector(environment.metrics(), (StatementNameStrategy)new SanerNamingStrategy()));
        if (configuration.isAutoCommentsEnabled()) {
            dbi.setStatementRewriter((StatementRewriter)new NamePrependingStatementRewriter((StatementRewriter)new ColonPrefixNamedParamStatementRewriter()));
        }
        dbi.registerArgumentFactory((ArgumentFactory)new OptionalArgumentFactory(configuration.getDriverClass()));
        dbi.registerContainerFactory((ContainerFactory)new ImmutableListContainerFactory());
        dbi.registerContainerFactory((ContainerFactory)new ImmutableSetContainerFactory());
        dbi.registerContainerFactory((ContainerFactory)new OptionalContainerFactory());
        dbi.registerArgumentFactory((ArgumentFactory)new JodaDateTimeArgumentFactory());
        dbi.registerMapper((ResultSetMapper)new JodaDateTimeMapper());
        return dbi;
    }

    private static class SanerNamingStrategy
    extends DelegatingStatementNameStrategy {
        private SanerNamingStrategy() {
            super(new StatementNameStrategy[]{NameStrategies.CHECK_EMPTY, NameStrategies.CONTEXT_CLASS, NameStrategies.CONTEXT_NAME, NameStrategies.SQL_OBJECT, new StatementNameStrategy(){

                public String getStatementName(StatementContext statementContext) {
                    return RAW_SQL;
                }
            }});
        }
    }
}

