/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.jersey;

import io.dropwizard.jersey.errors.LoggingExceptionMapper;
import java.sql.SQLException;
import javax.ws.rs.ext.Provider;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class LoggingDBIExceptionMapper
extends LoggingExceptionMapper<DBIException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingDBIExceptionMapper.class);

    protected void logException(long id, DBIException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof SQLException) {
            for (Throwable throwable : (SQLException)cause) {
                LOGGER.error(this.formatLogMessage(id, throwable), throwable);
            }
        } else {
            LOGGER.error(this.formatLogMessage(id, (Throwable)exception), (Throwable)exception);
        }
    }
}

