/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import com.google.common.base.Optional;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class GuavaOptionalArgumentFactory
implements ArgumentFactory<Optional<Object>> {
    private final String jdbcDriver;

    public GuavaOptionalArgumentFactory(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        return value instanceof Optional;
    }

    public Argument build(Class<?> expectedType, Optional<Object> value, StatementContext ctx) {
        if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(this.jdbcDriver)) {
            return new MsSqlOptionalArgument(value);
        }
        return new DefaultOptionalArgument(value);
    }

    private static class MsSqlOptionalArgument
    implements Argument {
        private final Optional<?> value;

        private MsSqlOptionalArgument(Optional<?> value) {
            this.value = value;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            statement.setObject(position, this.value.orNull());
        }
    }

    private static class DefaultOptionalArgument
    implements Argument {
        private final Optional<?> value;

        private DefaultOptionalArgument(Optional<?> value) {
            this.value = value;
        }

        public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
            if (this.value.isPresent()) {
                statement.setObject(position, this.value.get());
            } else {
                statement.setNull(position, 1111);
            }
        }
    }
}

