/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public class OffsetDateTimeMapper
implements ResultColumnMapper<OffsetDateTime> {
    private Optional<Calendar> calendar;

    public OffsetDateTimeMapper() {
        this.calendar = Optional.empty();
    }

    public OffsetDateTimeMapper(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    private Calendar cloneCalendar() {
        return (Calendar)this.calendar.get().clone();
    }

    public OffsetDateTime mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        Timestamp timestamp = this.calendar.isPresent() ? r.getTimestamp(columnNumber, this.cloneCalendar()) : r.getTimestamp(columnNumber);
        return this.convertToOffsetDateTime(timestamp);
    }

    public OffsetDateTime mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        Timestamp timestamp = this.calendar.isPresent() ? r.getTimestamp(columnLabel, this.cloneCalendar()) : r.getTimestamp(columnLabel);
        return this.convertToOffsetDateTime(timestamp);
    }

    private OffsetDateTime convertToOffsetDateTime(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        Optional zoneId = this.calendar.flatMap(c -> Optional.of(c.getTimeZone().toZoneId()));
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(timestamp.getTime()), zoneId.orElse(ZoneId.systemDefault()));
    }
}

