/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import io.dropwizard.jdbi.args.OffsetDateTimeArgument;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class OptionalOffsetDateTimeArgumentFactory
implements ArgumentFactory<Optional<OffsetDateTime>> {
    private final Optional<Calendar> calendar;

    public OptionalOffsetDateTimeArgumentFactory() {
        this.calendar = Optional.empty();
    }

    public OptionalOffsetDateTimeArgumentFactory(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        if (value instanceof Optional) {
            Optional optionalValue = (Optional)value;
            return optionalValue.isPresent() && optionalValue.get() instanceof OffsetDateTime;
        }
        return false;
    }

    public Argument build(Class<?> expectedType, Optional<OffsetDateTime> value, StatementContext ctx) {
        return new OffsetDateTimeArgument(value.get(), this.calendar);
    }
}

