/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import io.dropwizard.jdbi.args.JodaDateTimeArgument;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

public class OptionalJodaTimeArgumentFactory
implements ArgumentFactory<Optional<DateTime>> {
    private final Optional<Calendar> calendar;

    public OptionalJodaTimeArgumentFactory() {
        this.calendar = Optional.empty();
    }

    public OptionalJodaTimeArgumentFactory(Optional<TimeZone> timeZone) {
        this.calendar = timeZone.map(GregorianCalendar::new);
    }

    public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
        if (value instanceof Optional) {
            Optional optionalValue = (Optional)value;
            return optionalValue.isPresent() && optionalValue.get() instanceof DateTime;
        }
        return false;
    }

    public Argument build(Class<?> expectedType, Optional<DateTime> value, StatementContext ctx) {
        return new JodaDateTimeArgument(value.get(), this.calendar);
    }
}

