/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.Optional;
import javax.annotation.Nullable;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

public class InstantArgument
implements Argument {
    @Nullable
    private final Instant instant;
    private final Optional<Calendar> calendar;

    protected InstantArgument(@Nullable Instant instant, Optional<Calendar> calendar) {
        this.instant = instant;
        this.calendar = calendar;
    }

    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.instant != null) {
            if (this.calendar.isPresent()) {
                Calendar calendarClone = (Calendar)this.calendar.get().clone();
                statement.setTimestamp(position, Timestamp.from(this.instant), calendarClone);
            } else {
                statement.setTimestamp(position, Timestamp.from(this.instant));
            }
        } else {
            statement.setNull(position, 93);
        }
    }
}

