/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public class InstantMapper
implements ResultColumnMapper<Instant> {
    private final Optional<Calendar> calendar;

    public InstantMapper() {
        this(Optional.empty());
    }

    public InstantMapper(Optional<TimeZone> tz) {
        this.calendar = tz.map(GregorianCalendar::new);
    }

    @Nullable
    public Instant mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        Timestamp timestamp = this.calendar.isPresent() ? r.getTimestamp(columnNumber, this.cloneCalendar()) : r.getTimestamp(columnNumber);
        return timestamp == null ? null : timestamp.toInstant();
    }

    @Nullable
    public Instant mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        Timestamp timestamp = this.calendar.isPresent() ? r.getTimestamp(columnLabel, this.cloneCalendar()) : r.getTimestamp(columnLabel);
        return timestamp == null ? null : timestamp.toInstant();
    }

    private Calendar cloneCalendar() {
        return (Calendar)this.calendar.get().clone();
    }
}

