/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.db.TimeBoundHealthCheck;
import io.dropwizard.util.DirectExecutorService;
import io.dropwizard.util.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;

public class DBIHealthCheck
extends HealthCheck {
    private final DBI dbi;
    private final Optional<String> validationQuery;
    private final int validationQueryTimeout;
    private final TimeBoundHealthCheck timeBoundHealthCheck;

    public DBIHealthCheck(ExecutorService executorService, Duration duration, DBI dbi, Optional<String> validationQuery) {
        this.dbi = dbi;
        this.validationQuery = validationQuery;
        this.validationQueryTimeout = (int)duration.toSeconds();
        this.timeBoundHealthCheck = new TimeBoundHealthCheck(executorService, duration);
    }

    public DBIHealthCheck(DBI dbi, Optional<String> validationQuery) {
        this((ExecutorService)new DirectExecutorService(), Duration.seconds((long)0L), dbi, validationQuery);
    }

    protected HealthCheck.Result check() throws Exception {
        return this.timeBoundHealthCheck.check(() -> {
            try (Handle handle = this.dbi.open();){
                if (this.validationQuery.isPresent()) {
                    handle.execute(this.validationQuery.get(), new Object[0]);
                } else if (!handle.getConnection().isValid(this.validationQueryTimeout)) {
                    HealthCheck.Result result = HealthCheck.Result.unhealthy((String)"Connection::isValid returned false.");
                    return result;
                }
                HealthCheck.Result result = HealthCheck.Result.healthy();
                return result;
            }
        });
    }
}

