/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.args;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultColumnMapper;

public class InstantMapper
implements ResultColumnMapper<Instant> {
    private final Optional<Calendar> calendar;

    public InstantMapper() {
        this(Optional.empty());
    }

    public InstantMapper(Optional<TimeZone> tz) {
        this.calendar = tz.map(GregorianCalendar::new);
    }

    @Nullable
    public Instant mapColumn(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        Optional<Calendar> instance = this.cloneCalendar();
        Timestamp timestamp = instance.isPresent() ? r.getTimestamp(columnNumber, instance.get()) : r.getTimestamp(columnNumber);
        return timestamp == null ? null : timestamp.toInstant();
    }

    @Nullable
    public Instant mapColumn(ResultSet r, String columnLabel, StatementContext ctx) throws SQLException {
        Optional<Calendar> instance = this.cloneCalendar();
        Timestamp timestamp = instance.isPresent() ? r.getTimestamp(columnLabel, instance.get()) : r.getTimestamp(columnLabel);
        return timestamp == null ? null : timestamp.toInstant();
    }

    private Optional<Calendar> cloneCalendar() {
        return this.calendar.map(Calendar::clone).map(x -> (Calendar)x);
    }
}

