/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi.jersey;

import io.dropwizard.jersey.errors.LoggingExceptionMapper;
import java.sql.SQLException;
import javax.ws.rs.ext.Provider;
import org.skife.jdbi.v2.exceptions.DBIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class LoggingDBIExceptionMapper
extends LoggingExceptionMapper<DBIException> {
    public LoggingDBIExceptionMapper() {
        this(LoggerFactory.getLogger(LoggingDBIExceptionMapper.class));
    }

    LoggingDBIExceptionMapper(Logger logger) {
        super(logger);
    }

    protected void logException(long id, DBIException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof SQLException) {
            for (Throwable throwable : (SQLException)cause) {
                this.logger.error(this.formatLogMessage(id, throwable), throwable);
            }
        } else {
            this.logger.error(this.formatLogMessage(id, (Throwable)exception), (Throwable)exception);
        }
    }
}

