/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi3;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.util.concurrent.MoreExecutors;
import io.dropwizard.db.TimeBoundHealthCheck;
import io.dropwizard.util.Duration;
import java.util.concurrent.ExecutorService;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public class JdbiHealthCheck
extends HealthCheck {
    private final Jdbi jdbi;
    private final String validationQuery;
    private final TimeBoundHealthCheck timeBoundHealthCheck;

    public JdbiHealthCheck(ExecutorService executorService, Duration duration, Jdbi jdbi, String validationQuery) {
        this.jdbi = jdbi;
        this.validationQuery = validationQuery;
        this.timeBoundHealthCheck = new TimeBoundHealthCheck(executorService, duration);
    }

    public JdbiHealthCheck(Jdbi jdbi, String validationQuery) {
        this((ExecutorService)MoreExecutors.newDirectExecutorService(), Duration.seconds((long)0L), jdbi, validationQuery);
    }

    protected HealthCheck.Result check() throws Exception {
        return this.timeBoundHealthCheck.check(() -> {
            try (Handle handle = this.jdbi.open();){
                handle.execute(this.validationQuery, new Object[0]);
                HealthCheck.Result result = HealthCheck.Result.healthy();
                return result;
            }
        });
    }
}

