/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi3;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.jdbi3.InstrumentedTimingCollector;
import com.codahale.metrics.jdbi3.strategies.SmartNameStrategy;
import com.codahale.metrics.jdbi3.strategies.StatementNameStrategy;
import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.jdbi3.JdbiHealthCheck;
import io.dropwizard.jdbi3.NamePrependingTemplateEngine;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.TemplateEngine;
import org.jdbi.v3.core.statement.TimingCollector;
import org.jdbi.v3.guava.GuavaPlugin;
import org.jdbi.v3.jodatime2.JodaTimePlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;

public class JdbiFactory {
    private final StatementNameStrategy nameStrategy;

    public JdbiFactory() {
        this((StatementNameStrategy)new SmartNameStrategy());
    }

    public JdbiFactory(StatementNameStrategy nameStrategy) {
        this.nameStrategy = nameStrategy;
    }

    public Jdbi build(Environment environment, PooledDataSourceFactory configuration, String name) {
        ManagedDataSource dataSource = configuration.build(environment.metrics(), name);
        return this.build(environment, configuration, dataSource, name);
    }

    public Jdbi build(Environment environment, PooledDataSourceFactory configuration, ManagedDataSource dataSource, String name) {
        Jdbi jdbi = this.newInstance(dataSource);
        environment.lifecycle().manage((Managed)dataSource);
        String validationQuery = configuration.getValidationQuery();
        environment.healthChecks().register(name, (HealthCheck)new JdbiHealthCheck(environment.getHealthCheckExecutorService(), configuration.getValidationQueryTimeout().orElseGet(() -> Duration.seconds((long)5L)), jdbi, validationQuery));
        jdbi.setTimingCollector((TimingCollector)new InstrumentedTimingCollector(environment.metrics(), this.nameStrategy));
        if (configuration.isAutoCommentsEnabled()) {
            TemplateEngine original = ((SqlStatements)jdbi.getConfig(SqlStatements.class)).getTemplateEngine();
            jdbi.setTemplateEngine((TemplateEngine)new NamePrependingTemplateEngine(original));
        }
        this.configure(jdbi);
        return jdbi;
    }

    protected Jdbi newInstance(ManagedDataSource dataSource) {
        return Jdbi.create((DataSource)dataSource);
    }

    protected void configure(Jdbi jdbi) {
        jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        jdbi.installPlugin((JdbiPlugin)new JodaTimePlugin());
        jdbi.installPlugin((JdbiPlugin)new GuavaPlugin());
    }
}

