/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi3.jersey;

import com.google.common.annotations.VisibleForTesting;
import io.dropwizard.jersey.errors.LoggingExceptionMapper;
import java.sql.SQLException;
import javax.ws.rs.ext.Provider;
import org.jdbi.v3.core.JdbiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class LoggingJdbiExceptionMapper
extends LoggingExceptionMapper<JdbiException> {
    private static Logger logger = LoggerFactory.getLogger(LoggingJdbiExceptionMapper.class);

    protected void logException(long id, JdbiException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof SQLException) {
            for (Throwable throwable : (SQLException)cause) {
                logger.error(this.formatLogMessage(id, throwable), throwable);
            }
        } else {
            logger.error(this.formatLogMessage(id, (Throwable)exception), (Throwable)exception);
        }
    }

    @VisibleForTesting
    static synchronized void setLogger(Logger newLogger) {
        logger = newLogger;
    }
}

