/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi3;

import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.db.TimeBoundHealthCheck;
import io.dropwizard.util.DirectExecutorService;
import io.dropwizard.util.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;

public class JdbiHealthCheck
extends HealthCheck {
    private final Jdbi jdbi;
    private final Optional<String> validationQuery;
    private final int validationQueryTimeout;
    private final TimeBoundHealthCheck timeBoundHealthCheck;

    public JdbiHealthCheck(ExecutorService executorService, Duration duration, Jdbi jdbi, Optional<String> validationQuery) {
        this.jdbi = jdbi;
        this.validationQuery = validationQuery;
        this.validationQueryTimeout = (int)duration.toSeconds();
        this.timeBoundHealthCheck = new TimeBoundHealthCheck(executorService, duration);
    }

    public JdbiHealthCheck(Jdbi jdbi, Optional<String> validationQuery) {
        this((ExecutorService)new DirectExecutorService(), Duration.seconds((long)0L), jdbi, validationQuery);
    }

    protected HealthCheck.Result check() throws Exception {
        return this.timeBoundHealthCheck.check(() -> {
            try (Handle handle = this.jdbi.open();){
                if (this.validationQuery.isPresent()) {
                    handle.execute(this.validationQuery.get(), new Object[0]);
                } else if (!handle.getConnection().isValid(this.validationQueryTimeout)) {
                    HealthCheck.Result result = HealthCheck.Result.unhealthy((String)"Connection::isValid returned false.");
                    return result;
                }
                HealthCheck.Result result = HealthCheck.Result.healthy();
                return result;
            }
        });
    }
}

