/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.sessions;

import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import io.dropwizard.jersey.sessions.Flash;
import io.dropwizard.jersey.sessions.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Provider
public class FlashProvider
implements InjectableProvider<Session, Parameter> {
    private final ThreadLocal<HttpServletRequest> request;

    public FlashProvider(@Context ThreadLocal<HttpServletRequest> request) {
        this.request = request;
    }

    public ComponentScope getScope() {
        return ComponentScope.PerRequest;
    }

    public Injectable<?> getInjectable(ComponentContext ic, final Session annotation, Parameter parameter) {
        if (parameter.getParameterClass().isAssignableFrom(Flash.class)) {
            return new Injectable<Flash<?>>(){

                public Flash<?> getValue() {
                    HttpServletRequest req = (HttpServletRequest)FlashProvider.this.request.get();
                    if (req != null) {
                        HttpSession session = req.getSession(!annotation.doNotCreate());
                        if (session != null) {
                            return new Flash(session);
                        }
                        return null;
                    }
                    return null;
                }
            };
        }
        return null;
    }
}

