/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.sessions;

import com.sun.jersey.api.model.Parameter;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import io.dropwizard.jersey.sessions.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Provider
public class HttpSessionProvider
implements InjectableProvider<Session, Parameter> {
    private final ThreadLocal<HttpServletRequest> request;

    public HttpSessionProvider(@Context ThreadLocal<HttpServletRequest> request) {
        this.request = request;
    }

    public ComponentScope getScope() {
        return ComponentScope.PerRequest;
    }

    public Injectable<?> getInjectable(ComponentContext ic, final Session session, Parameter parameter) {
        if (parameter.getParameterClass().isAssignableFrom(HttpSession.class)) {
            return new Injectable<HttpSession>(){

                public HttpSession getValue() {
                    HttpServletRequest req = (HttpServletRequest)HttpSessionProvider.this.request.get();
                    if (req != null) {
                        return req.getSession(!session.doNotCreate());
                    }
                    return null;
                }
            };
        }
        return null;
    }
}

