/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.setup;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.scanning.PackageNamesScanner;
import com.sun.jersey.core.spi.scanning.Scanner;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import io.dropwizard.jersey.DropwizardResourceConfig;
import io.dropwizard.jersey.setup.JerseyContainerHolder;
import javax.annotation.Nullable;

public class JerseyEnvironment {
    private final JerseyContainerHolder holder;
    private final DropwizardResourceConfig config;

    public JerseyEnvironment(JerseyContainerHolder holder, DropwizardResourceConfig config) {
        this.holder = holder;
        this.config = config;
    }

    public void disable() {
        this.holder.setContainer(null);
    }

    public void replace(Function<ResourceConfig, ServletContainer> replace) {
        this.holder.setContainer((ServletContainer)replace.apply((Object)this.config));
    }

    public void register(Object component) {
        this.config.getSingletons().add(Preconditions.checkNotNull((Object)component));
    }

    public void register(Class<?> componentClass) {
        this.config.getClasses().add(Preconditions.checkNotNull(componentClass));
    }

    public void packages(String ... packages) {
        this.config.init((Scanner)new PackageNamesScanner((String[])Preconditions.checkNotNull((Object)packages)));
    }

    public void enable(String featureName) {
        this.config.getFeatures().put(Preconditions.checkNotNull((Object)featureName), Boolean.TRUE);
    }

    public void disable(String featureName) {
        this.config.getFeatures().put(Preconditions.checkNotNull((Object)featureName), Boolean.FALSE);
    }

    public void property(String name, @Nullable Object value) {
        this.config.getProperties().put(Preconditions.checkNotNull((Object)name), value);
    }

    public <T> T getProperty(String name) {
        return (T)this.config.getProperties().get(name);
    }

    public String getUrlPattern() {
        return this.config.getUrlPattern();
    }

    public void setUrlPattern(String urlPattern) {
        this.config.setUrlPattern(urlPattern);
    }

    public ResourceConfig getResourceConfig() {
        return this.config;
    }
}

