/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.sessions;

import com.google.common.base.Optional;
import javax.servlet.http.HttpSession;

public class Flash<T> {
    private static final String ATTRIBUTE = "flash";
    private final HttpSession session;
    private final T value;

    Flash(HttpSession session) {
        this.session = session;
        this.value = session.getAttribute(ATTRIBUTE);
        if (this.value != null) {
            session.removeAttribute(ATTRIBUTE);
        }
    }

    public Optional<T> get() {
        return Optional.fromNullable(this.value);
    }

    public void set(T value) {
        this.session.setAttribute(ATTRIBUTE, value);
    }
}

