/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.validation;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.dropwizard.jersey.errors.ErrorMessage;
import io.dropwizard.jersey.validation.JerseyParameterNameProvider;
import io.dropwizard.util.Enums;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class FuzzyEnumParamConverterProvider
implements ParamConverterProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParamConverterProvider.class);
    private static final Joiner JOINER = Joiner.on((String)", ");

    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (!rawType.isEnum()) {
            return null;
        }
        Class<T> type = rawType;
        final Enum[] constants = (Enum[])type.getEnumConstants();
        final String parameterName = JerseyParameterNameProvider.getParameterNameFromAnnotations(annotations).orElse("Parameter");
        final Method fromStringMethod = (Method)AccessController.doPrivileged(ReflectionHelper.getFromStringStringMethodPA(rawType));
        return new ParamConverter<T>(){

            public T fromString(String value) {
                if (Strings.isNullOrEmpty((String)value)) {
                    return null;
                }
                if (fromStringMethod != null) {
                    try {
                        Object constant = fromStringMethod.invoke(null, value);
                        if (constant != null) {
                            return constant;
                        }
                        String errMsg = String.format("%s is not a valid %s", parameterName, rawType.getSimpleName());
                        throw new WebApplicationException(this.getErrorResponse(errMsg));
                    }
                    catch (IllegalAccessException e) {
                        String errMsg = String.format("Not permitted to call fromString on %s", rawType.getSimpleName());
                        LOGGER.debug(errMsg, (Throwable)e);
                        throw new WebApplicationException(this.getErrorResponse(errMsg));
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof WebApplicationException) {
                            throw (WebApplicationException)e.getCause();
                        }
                        String errMsg = String.format("Failed to convert %s to %s", parameterName, rawType.getSimpleName());
                        LOGGER.debug(errMsg, (Throwable)e);
                        throw new WebApplicationException(this.getErrorResponse(errMsg));
                    }
                }
                Enum constant = Enums.fromStringFuzzy((String)value, (Enum[])constants);
                if (constant != null) {
                    return constant;
                }
                String errMsg = String.format("%s must be one of [%s]", parameterName, JOINER.join((Object[])constants));
                throw new WebApplicationException(this.getErrorResponse(errMsg));
            }

            public String toString(T value) {
                return value.toString();
            }

            protected Response getErrorResponse(String message) {
                return Response.status((int)400).entity((Object)new ErrorMessage(400, message)).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
        };
    }
}

