/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.validation;

import io.dropwizard.util.Enums;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class FuzzyEnumParamConverter<T>
implements ParamConverter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FuzzyEnumParamConverter.class);
    private final Class<T> rawType;
    private final Method fromStringMethod;
    private final Enum<?>[] constants;
    private final String parameterName;

    FuzzyEnumParamConverter(Class<T> rawType, Method fromStringMethod, Enum<?>[] constants, String parameterName) {
        this.rawType = rawType;
        this.fromStringMethod = fromStringMethod;
        this.constants = constants;
        this.parameterName = parameterName;
    }

    public @Nullable T fromString(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (this.fromStringMethod != null) {
            try {
                Object constant = this.fromStringMethod.invoke(null, value);
                if (constant != null) {
                    Object returnValue = constant;
                    return (T)returnValue;
                }
                String errMsg = String.format("%s is not a valid %s", this.parameterName, this.rawType.getSimpleName());
                throw new BadRequestException(errMsg);
            }
            catch (IllegalAccessException e) {
                LOGGER.debug("Not permitted to call fromString on {}", (Object)this.rawType.getSimpleName(), (Object)e);
                throw new BadRequestException("Not permitted to call fromString on " + this.rawType.getSimpleName());
            }
            catch (InvocationTargetException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof WebApplicationException) {
                    WebApplicationException webApplicationException = (WebApplicationException)throwable;
                    throw webApplicationException;
                }
                LOGGER.debug("Failed to convert {} to {}", new Object[]{this.parameterName, this.rawType.getSimpleName(), e});
                throw new BadRequestException("Failed to convert " + this.parameterName + " to " + this.rawType.getSimpleName());
            }
        }
        Enum constant = Enums.fromStringFuzzy((String)value, (Enum[])this.constants);
        if (constant != null) {
            Enum returnValue = constant;
            return (T)returnValue;
        }
        String constantsList = Arrays.stream(this.constants).map(Enum::toString).collect(Collectors.joining(", "));
        String errMsg = String.format("%s must be one of [%s]", this.parameterName, constantsList);
        throw new BadRequestException(errMsg);
    }

    public String toString(T value) {
        return value.toString();
    }
}

