/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.servlets.IncludableGzipFilter;

public class BiDiGzipFilter
extends IncludableGzipFilter {
    private final ThreadLocal<Deflater> localDeflater = new ThreadLocal();

    public Set<String> getMimeTypes() {
        return this._mimeTypes;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public int getMinGzipSize() {
        return this._minGzipSize;
    }

    public int getDeflateCompressionLevel() {
        return this._deflateCompressionLevel;
    }

    public boolean isDeflateNoWrap() {
        return this._deflateNoWrap;
    }

    public Set<String> getMethods() {
        return this._methods;
    }

    public Set<String> getExcludedAgents() {
        return this._excludedAgents;
    }

    public Set<Pattern> getExcludedAgentPatterns() {
        return this._excludedAgentPatterns;
    }

    public Set<String> getExcludedPaths() {
        return this._excludedPaths;
    }

    public Set<Pattern> getExcludedPathPatterns() {
        return this._excludedPathPatterns;
    }

    public String getVary() {
        return this._vary;
    }

    public void setMimeTypes(Set<String> mimeTypes) {
        this._mimeTypes.clear();
        this._mimeTypes.addAll(mimeTypes);
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void setMinGzipSize(int minGzipSize) {
        this._minGzipSize = minGzipSize;
    }

    public void setDeflateCompressionLevel(int level) {
        this._deflateCompressionLevel = level;
    }

    public void setDeflateNoWrap(boolean noWrap) {
        this._deflateNoWrap = noWrap;
    }

    public void setMethods(Set<String> methods) {
        this._methods.clear();
        this._methods.addAll(methods);
    }

    public void setExcludedAgents(Set<String> userAgents) {
        this._excludedAgents = userAgents;
    }

    public void setExcludedAgentPatterns(Set<Pattern> userAgentPatterns) {
        this._excludedAgentPatterns = userAgentPatterns;
    }

    public void setExcludedPaths(Set<String> paths) {
        this._excludedPaths = paths;
    }

    public void setExcludedPathPatterns(Set<Pattern> patterns) {
        this._excludedPathPatterns = patterns;
    }

    public void setVary(String vary) {
        this._vary = vary;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String encoding = request.getHeader(HttpHeader.CONTENT_ENCODING.asString());
        if ("gzip".equalsIgnoreCase(encoding)) {
            super.doFilter(this.wrapGzippedRequest(request), res, chain);
        } else if ("deflate".equalsIgnoreCase(encoding)) {
            super.doFilter(this.wrapDeflatedRequest(request), res, chain);
        } else {
            super.doFilter(req, res, chain);
        }
    }

    private Deflater buildDeflater() {
        Deflater deflater = this.localDeflater.get();
        if (deflater != null) {
            return deflater;
        }
        return new Deflater(this._deflateCompressionLevel, this._deflateNoWrap);
    }

    private ServletRequest wrapDeflatedRequest(HttpServletRequest request) throws IOException {
        final Deflater deflater = this.buildDeflater();
        DeflaterInputStream input = new DeflaterInputStream((InputStream)request.getInputStream(), deflater, this._bufferSize){

            @Override
            public void close() throws IOException {
                deflater.reset();
                BiDiGzipFilter.this.localDeflater.set(deflater);
                super.close();
            }
        };
        return new WrappedServletRequest(request, input);
    }

    private ServletRequest wrapGzippedRequest(HttpServletRequest request) throws IOException {
        return new WrappedServletRequest(request, new GZIPInputStream((InputStream)request.getInputStream(), this._bufferSize));
    }

    private static class WrappedServletInputStream
    extends ServletInputStream {
        private final InputStream input;

        private WrappedServletInputStream(InputStream input) {
            this.input = input;
        }

        public void close() throws IOException {
            this.input.close();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.input.read(b, off, len);
        }

        public int available() throws IOException {
            return this.input.available();
        }

        public void mark(int readlimit) {
            this.input.mark(readlimit);
        }

        public boolean markSupported() {
            return this.input.markSupported();
        }

        public int read() throws IOException {
            return this.input.read();
        }

        public void reset() throws IOException {
            this.input.reset();
        }

        public long skip(long n) throws IOException {
            return this.input.skip(n);
        }

        public int read(byte[] b) throws IOException {
            return this.input.read(b);
        }
    }

    private static class WrappedServletRequest
    extends HttpServletRequestWrapper {
        private final ServletInputStream input;
        private final BufferedReader reader;

        private WrappedServletRequest(HttpServletRequest request, InputStream inputStream) throws IOException {
            super(request);
            this.input = new WrappedServletInputStream(inputStream);
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.input, this.getCharset()));
        }

        private Charset getCharset() {
            String encoding = this.getCharacterEncoding();
            if (encoding == null || !Charset.isSupported(encoding)) {
                return Charsets.ISO_8859_1;
            }
            return Charset.forName(encoding);
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.input;
        }

        public BufferedReader getReader() throws IOException {
            return this.reader;
        }
    }
}

