/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty.setup;

import com.google.common.base.Preconditions;
import io.dropwizard.jetty.MutableServletContextHandler;
import io.dropwizard.jetty.NonblockingServletHolder;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletEnvironment.class);
    private final MutableServletContextHandler handler;
    private final Set<String> servlets = new HashSet<String>();
    private final Set<String> filters = new HashSet<String>();

    public ServletEnvironment(MutableServletContextHandler handler) {
        this.handler = handler;
    }

    public ServletRegistration.Dynamic addServlet(String name, Servlet servlet) {
        NonblockingServletHolder holder = new NonblockingServletHolder((Servlet)Preconditions.checkNotNull((Object)servlet));
        holder.setName(name);
        this.handler.getServletHandler().addServlet((ServletHolder)holder);
        ServletRegistration.Dynamic registration = holder.getRegistration();
        this.checkDuplicateRegistration(name, this.servlets, "servlet");
        return registration;
    }

    public ServletRegistration.Dynamic addServlet(String name, Class<? extends Servlet> klass) {
        ServletHolder holder = new ServletHolder((Class)Preconditions.checkNotNull(klass));
        holder.setName(name);
        this.handler.getServletHandler().addServlet(holder);
        ServletRegistration.Dynamic registration = holder.getRegistration();
        this.checkDuplicateRegistration(name, this.servlets, "servlet");
        return registration;
    }

    public FilterRegistration.Dynamic addFilter(String name, Filter filter) {
        FilterHolder holder = new FilterHolder((Filter)Preconditions.checkNotNull((Object)filter));
        holder.setName(name);
        this.handler.getServletHandler().addFilter(holder);
        FilterRegistration.Dynamic registration = holder.getRegistration();
        this.checkDuplicateRegistration(name, this.filters, "filter");
        return registration;
    }

    public FilterRegistration.Dynamic addFilter(String name, Class<? extends Filter> klass) {
        FilterHolder holder = new FilterHolder((Class)Preconditions.checkNotNull(klass));
        holder.setName(name);
        this.handler.getServletHandler().addFilter(holder);
        FilterRegistration.Dynamic registration = holder.getRegistration();
        this.checkDuplicateRegistration(name, this.filters, "filter");
        return registration;
    }

    public void addServletListeners(EventListener ... listeners) {
        for (EventListener listener : listeners) {
            this.handler.addEventListener(listener);
        }
    }

    public void setProtectedTargets(String ... targets) {
        this.handler.setProtectedTargets(Arrays.copyOf(targets, targets.length));
    }

    public void setResourceBase(String resourceBase) {
        this.handler.setResourceBase(resourceBase);
    }

    public void setInitParameter(String name, String value) {
        this.handler.setInitParameter(name, value);
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.handler.setSessionsEnabled(sessionHandler != null);
        this.handler.setSessionHandler(sessionHandler);
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        this.handler.setSecurityEnabled(securityHandler != null);
        this.handler.setSecurityHandler(securityHandler);
    }

    public void addMimeMapping(String extension, String type) {
        this.handler.getMimeTypes().addMimeMapping(extension, type);
    }

    private void checkDuplicateRegistration(String name, Set<String> items, String type) {
        if (!items.add(name)) {
            LOGGER.warn("Overriding the existing {} registered with the name: {}", (Object)type, (Object)name);
        }
    }
}

