/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import com.google.common.collect.ImmutableSortedSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;

public class BiDiGzipHandler
extends GzipHandler {
    private final ThreadLocal<Inflater> localInflater = new ThreadLocal();
    private int inputBufferSize = 8192;
    private boolean inflateNoWrap = true;

    public boolean isInflateNoWrap() {
        return this.inflateNoWrap;
    }

    public void setInflateNoWrap(boolean inflateNoWrap) {
        this.inflateNoWrap = inflateNoWrap;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String encoding = request.getHeader(HttpHeader.CONTENT_ENCODING.asString());
        if ("gzip".equalsIgnoreCase(encoding)) {
            super.handle(target, baseRequest, (HttpServletRequest)this.wrapGzippedRequest(this.removeContentHeaders(request)), response);
        } else if ("deflate".equalsIgnoreCase(encoding)) {
            super.handle(target, baseRequest, (HttpServletRequest)this.wrapDeflatedRequest(this.removeContentHeaders(request)), response);
        } else {
            super.handle(target, baseRequest, request, response);
        }
    }

    private Inflater buildInflater() {
        Inflater inflater = this.localInflater.get();
        if (inflater != null) {
            this.localInflater.set(null);
            inflater.reset();
            return inflater;
        }
        return new Inflater(this.inflateNoWrap);
    }

    private WrappedServletRequest wrapDeflatedRequest(HttpServletRequest request) throws IOException {
        final Inflater inflater = this.buildInflater();
        InflaterInputStream input = new InflaterInputStream((InputStream)request.getInputStream(), inflater, this.inputBufferSize){

            @Override
            public void close() throws IOException {
                super.close();
                BiDiGzipHandler.this.localInflater.set(inflater);
            }
        };
        return new WrappedServletRequest(request, input);
    }

    private WrappedServletRequest wrapGzippedRequest(HttpServletRequest request) throws IOException {
        return new WrappedServletRequest(request, new GZIPInputStream((InputStream)request.getInputStream(), this.inputBufferSize));
    }

    private HttpServletRequest removeContentHeaders(HttpServletRequest request) {
        return new RemoveHttpHeadersWrapper(request, (ImmutableSortedSet<String>)ImmutableSortedSet.orderedBy(String::compareToIgnoreCase).add((Object)HttpHeader.CONTENT_ENCODING.asString()).add((Object)HttpHeader.CONTENT_LENGTH.asString()).build());
    }

    private static class RemoveHttpHeadersWrapper
    extends HttpServletRequestWrapper {
        private final ImmutableSortedSet<String> headerNames;

        RemoveHttpHeadersWrapper(HttpServletRequest request, ImmutableSortedSet<String> headerNames) {
            super(request);
            this.headerNames = headerNames;
        }

        public int getIntHeader(String name) {
            if (this.headerNames.contains((Object)name)) {
                return -1;
            }
            return super.getIntHeader(name);
        }

        public Enumeration<String> getHeaders(String name) {
            if (this.headerNames.contains((Object)name)) {
                return Collections.emptyEnumeration();
            }
            return super.getHeaders(name);
        }

        public String getHeader(String name) {
            if (this.headerNames.contains((Object)name)) {
                return null;
            }
            return super.getHeader(name);
        }

        public long getDateHeader(String name) {
            if (this.headerNames.contains((Object)name)) {
                return -1L;
            }
            return super.getDateHeader(name);
        }
    }

    private static class WrappedServletInputStream
    extends ServletInputStream {
        private final InputStream input;

        private WrappedServletInputStream(InputStream input) {
            this.input = input;
        }

        public void close() throws IOException {
            this.input.close();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.input.read(b, off, len);
        }

        public int available() throws IOException {
            return this.input.available();
        }

        public void mark(int readlimit) {
            this.input.mark(readlimit);
        }

        public boolean markSupported() {
            return this.input.markSupported();
        }

        public int read() throws IOException {
            return this.input.read();
        }

        public void reset() throws IOException {
            this.input.reset();
        }

        public long skip(long n) throws IOException {
            return this.input.skip(n);
        }

        public int read(byte[] b) throws IOException {
            return this.input.read(b);
        }

        public boolean isFinished() {
            try {
                return this.input.available() == 0;
            }
            catch (IOException iOException) {
                return true;
            }
        }

        public boolean isReady() {
            try {
                return this.input.available() > 0;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }
    }

    private static class WrappedServletRequest
    extends HttpServletRequestWrapper {
        private final ServletInputStream input;
        private final BufferedReader reader;

        private WrappedServletRequest(HttpServletRequest request, InputStream inputStream) throws IOException {
            super(request);
            this.input = new WrappedServletInputStream(inputStream);
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.input, this.getCharset()));
        }

        private Charset getCharset() {
            String encoding = this.getCharacterEncoding();
            if (encoding == null || !Charset.isSupported(encoding)) {
                return StandardCharsets.ISO_8859_1;
            }
            return Charset.forName(encoding);
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.input;
        }

        public BufferedReader getReader() throws IOException {
            return this.reader;
        }

        public int getContentLength() {
            return -1;
        }

        public long getContentLengthLong() {
            return -1L;
        }
    }
}

