/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.jetty.ConnectorFactory;
import io.dropwizard.jetty.Jetty93InstrumentedConnectionFactory;
import io.dropwizard.jetty.NetUtil;
import io.dropwizard.util.DataSize;
import io.dropwizard.util.DataSizeUnit;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDataSize;
import io.dropwizard.validation.MinDuration;
import io.dropwizard.validation.PortRange;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.valueextraction.Unwrapping;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

@JsonTypeName(value="http")
public class HttpConnectorFactory
implements ConnectorFactory {
    @PortRange
    private int port = 8080;
    @Nullable
    private String bindHost;
    private boolean inheritChannel = false;
    @NotNull
    @MinDataSize(value=128L)
    private @NotNull @MinDataSize(value=128L) DataSize headerCacheSize = DataSize.bytes((long)512L);
    @NotNull
    @MinDataSize(value=8L, unit=DataSizeUnit.KIBIBYTES)
    private @NotNull @MinDataSize(value=8L, unit=DataSizeUnit.KIBIBYTES) DataSize outputBufferSize = DataSize.kibibytes((long)32L);
    @NotNull
    @MinDataSize(value=1L, unit=DataSizeUnit.KIBIBYTES)
    private @NotNull @MinDataSize(value=1L, unit=DataSizeUnit.KIBIBYTES) DataSize maxRequestHeaderSize = DataSize.kibibytes((long)8L);
    @NotNull
    @MinDataSize(value=1L, unit=DataSizeUnit.KIBIBYTES)
    private @NotNull @MinDataSize(value=1L, unit=DataSizeUnit.KIBIBYTES) DataSize maxResponseHeaderSize = DataSize.kibibytes((long)8L);
    @NotNull
    @MinDataSize(value=1L, unit=DataSizeUnit.KIBIBYTES)
    private @NotNull @MinDataSize(value=1L, unit=DataSizeUnit.KIBIBYTES) DataSize inputBufferSize = DataSize.kibibytes((long)8L);
    @NotNull
    @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS)
    private @NotNull @MinDuration(value=1L, unit=TimeUnit.MILLISECONDS) Duration idleTimeout = Duration.seconds((long)30L);
    @NotNull
    @MinDataSize(value=0L)
    private @NotNull @MinDataSize(value=0L) DataSize minResponseDataPerSecond = DataSize.bytes((long)0L);
    @NotNull
    @MinDataSize(value=0L)
    private @NotNull @MinDataSize(value=0L) DataSize minRequestDataPerSecond = DataSize.bytes((long)0L);
    @NotNull
    @MinDataSize(value=1L, unit=DataSizeUnit.BYTES)
    private @NotNull @MinDataSize(value=1L, unit=DataSizeUnit.BYTES) DataSize minBufferPoolSize = DataSize.bytes((long)64L);
    @NotNull
    @MinDataSize(value=1L, unit=DataSizeUnit.BYTES)
    private @NotNull @MinDataSize(value=1L, unit=DataSizeUnit.BYTES) DataSize bufferPoolIncrement = DataSize.bytes((long)1024L);
    @NotNull
    @MinDataSize(value=1L, unit=DataSizeUnit.BYTES)
    private @NotNull @MinDataSize(value=1L, unit=DataSizeUnit.BYTES) DataSize maxBufferPoolSize = DataSize.kibibytes((long)64L);
    @Min(value=1L, payload={Unwrapping.Unwrap.class})
    private @Min(value=1L, payload={Unwrapping.Unwrap.class}) Optional<Integer> acceptorThreads = Optional.empty();
    @Min(value=1L, payload={Unwrapping.Unwrap.class})
    private @Min(value=1L, payload={Unwrapping.Unwrap.class}) Optional<Integer> selectorThreads = Optional.empty();
    @Min(value=0L)
    @Nullable
    private @Min(value=0L) Integer acceptQueueSize;
    private boolean reuseAddress = true;
    private boolean useServerHeader = false;
    private boolean useDateHeader = true;
    private boolean useForwardedHeaders = false;
    private boolean useProxyProtocol = false;
    private HttpCompliance httpCompliance = HttpCompliance.RFC7230;
    private CookieCompliance requestCookieCompliance = CookieCompliance.RFC6265;
    private CookieCompliance responseCookieCompliance = CookieCompliance.RFC6265;

    public static ConnectorFactory application() {
        HttpConnectorFactory factory = new HttpConnectorFactory();
        factory.port = 8080;
        return factory;
    }

    public static ConnectorFactory admin() {
        HttpConnectorFactory factory = new HttpConnectorFactory();
        factory.port = 8081;
        return factory;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(int port) {
        this.port = port;
    }

    @JsonProperty
    @Nullable
    public String getBindHost() {
        return this.bindHost;
    }

    @JsonProperty
    public void setBindHost(String bindHost) {
        this.bindHost = bindHost;
    }

    @JsonProperty
    public boolean isInheritChannel() {
        return this.inheritChannel;
    }

    @JsonProperty
    public void setInheritChannel(boolean inheritChannel) {
        this.inheritChannel = inheritChannel;
    }

    @JsonProperty
    public DataSize getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    @JsonProperty
    public void setHeaderCacheSize(DataSize headerCacheSize) {
        this.headerCacheSize = headerCacheSize;
    }

    @JsonProperty
    public DataSize getOutputBufferSize() {
        return this.outputBufferSize;
    }

    @JsonProperty
    public void setOutputBufferSize(DataSize outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    @JsonProperty
    public DataSize getMaxRequestHeaderSize() {
        return this.maxRequestHeaderSize;
    }

    @JsonProperty
    public void setMaxRequestHeaderSize(DataSize maxRequestHeaderSize) {
        this.maxRequestHeaderSize = maxRequestHeaderSize;
    }

    @JsonProperty
    public DataSize getMaxResponseHeaderSize() {
        return this.maxResponseHeaderSize;
    }

    @JsonProperty
    public void setMaxResponseHeaderSize(DataSize maxResponseHeaderSize) {
        this.maxResponseHeaderSize = maxResponseHeaderSize;
    }

    @JsonProperty
    public DataSize getInputBufferSize() {
        return this.inputBufferSize;
    }

    @JsonProperty
    public void setInputBufferSize(DataSize inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    @JsonProperty
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @JsonProperty
    public void setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @JsonProperty
    public DataSize getMinBufferPoolSize() {
        return this.minBufferPoolSize;
    }

    @JsonProperty
    public void setMinBufferPoolSize(DataSize minBufferPoolSize) {
        this.minBufferPoolSize = minBufferPoolSize;
    }

    @JsonProperty
    public DataSize getBufferPoolIncrement() {
        return this.bufferPoolIncrement;
    }

    @JsonProperty
    public void setBufferPoolIncrement(DataSize bufferPoolIncrement) {
        this.bufferPoolIncrement = bufferPoolIncrement;
    }

    @JsonProperty
    public DataSize getMaxBufferPoolSize() {
        return this.maxBufferPoolSize;
    }

    @JsonProperty
    public void setMaxBufferPoolSize(DataSize maxBufferPoolSize) {
        this.maxBufferPoolSize = maxBufferPoolSize;
    }

    @JsonProperty
    public DataSize getMinResponseDataPerSecond() {
        return this.minResponseDataPerSecond;
    }

    @JsonProperty
    public void setMinResponseDataPerSecond(DataSize minResponseDataPerSecond) {
        this.minResponseDataPerSecond = minResponseDataPerSecond;
    }

    @JsonProperty
    public DataSize getMinRequestDataPerSecond() {
        return this.minRequestDataPerSecond;
    }

    @JsonProperty
    public void setMinRequestDataPerSecond(DataSize minRequestDataPerSecond) {
        this.minRequestDataPerSecond = minRequestDataPerSecond;
    }

    @JsonProperty
    public Optional<Integer> getAcceptorThreads() {
        return this.acceptorThreads;
    }

    @JsonProperty
    public void setAcceptorThreads(Optional<Integer> acceptorThreads) {
        this.acceptorThreads = acceptorThreads;
    }

    @JsonProperty
    public Optional<Integer> getSelectorThreads() {
        return this.selectorThreads;
    }

    @JsonProperty
    public void setSelectorThreads(Optional<Integer> selectorThreads) {
        this.selectorThreads = selectorThreads;
    }

    @JsonProperty
    @Nullable
    public Integer getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    @JsonProperty
    public void setAcceptQueueSize(Integer acceptQueueSize) {
        this.acceptQueueSize = acceptQueueSize;
    }

    @JsonProperty
    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    @JsonProperty
    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    @JsonProperty
    public boolean isUseServerHeader() {
        return this.useServerHeader;
    }

    @JsonProperty
    public void setUseServerHeader(boolean useServerHeader) {
        this.useServerHeader = useServerHeader;
    }

    @JsonProperty
    public boolean isUseDateHeader() {
        return this.useDateHeader;
    }

    @JsonProperty
    public void setUseDateHeader(boolean useDateHeader) {
        this.useDateHeader = useDateHeader;
    }

    @JsonProperty
    public boolean isUseForwardedHeaders() {
        return this.useForwardedHeaders;
    }

    @JsonProperty
    public void setUseForwardedHeaders(boolean useForwardedHeaders) {
        this.useForwardedHeaders = useForwardedHeaders;
    }

    @JsonProperty
    public boolean isUseProxyProtocol() {
        return this.useProxyProtocol;
    }

    @JsonProperty
    public void setUseProxyProtocol(boolean useProxyProtocol) {
        this.useProxyProtocol = useProxyProtocol;
    }

    @JsonProperty
    public HttpCompliance getHttpCompliance() {
        return this.httpCompliance;
    }

    @JsonProperty
    public void setHttpCompliance(HttpCompliance httpCompliance) {
        this.httpCompliance = httpCompliance;
    }

    @JsonProperty
    public CookieCompliance getRequestCookieCompliance() {
        return this.requestCookieCompliance;
    }

    @JsonProperty
    public void setRequestCookieCompliance(CookieCompliance requestCookieCompliance) {
        this.requestCookieCompliance = requestCookieCompliance;
    }

    @JsonProperty
    public CookieCompliance getResponseCookieCompliance() {
        return this.responseCookieCompliance;
    }

    @JsonProperty
    public void setResponseCookieCompliance(CookieCompliance responseCookieCompliance) {
        this.responseCookieCompliance = responseCookieCompliance;
    }

    @Override
    public Connector build(Server server, MetricRegistry metrics, String name, @Nullable ThreadPool threadPool) {
        HttpConfiguration httpConfig = this.buildHttpConfiguration();
        HttpConnectionFactory httpConnectionFactory = this.buildHttpConnectionFactory(httpConfig);
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler();
        ByteBufferPool bufferPool = this.buildBufferPool();
        return this.buildConnector(server, (Scheduler)scheduler, bufferPool, name, threadPool, new Jetty93InstrumentedConnectionFactory((ConnectionFactory)httpConnectionFactory, metrics.timer(this.httpConnections())));
    }

    protected String httpConnections() {
        return MetricRegistry.name(HttpConnectionFactory.class, (String[])new String[]{this.bindHost, Integer.toString(this.port), "connections"});
    }

    protected ServerConnector buildConnector(Server server, Scheduler scheduler, ByteBufferPool bufferPool, String name, @Nullable ThreadPool threadPool, ConnectionFactory ... factories) {
        if (this.useProxyProtocol) {
            factories = (ConnectionFactory[])ArrayUtil.prependToArray((Object)new ProxyConnectionFactory(), (Object[])factories, ConnectorFactory.class);
        }
        ServerConnector connector = new ServerConnector(server, (Executor)threadPool, scheduler, bufferPool, this.acceptorThreads.orElse(-1).intValue(), this.selectorThreads.orElse(-1).intValue(), factories);
        connector.setPort(this.port);
        connector.setHost(this.bindHost);
        connector.setInheritChannel(this.inheritChannel);
        if (this.acceptQueueSize != null) {
            connector.setAcceptQueueSize(this.acceptQueueSize.intValue());
        } else {
            connector.setAcceptQueueSize(NetUtil.getTcpBacklog());
        }
        connector.setReuseAddress(this.reuseAddress);
        connector.setIdleTimeout(this.idleTimeout.toMilliseconds());
        connector.setName(name);
        return connector;
    }

    protected HttpConnectionFactory buildHttpConnectionFactory(HttpConfiguration httpConfig) {
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(httpConfig, this.httpCompliance);
        httpConnectionFactory.setInputBufferSize((int)this.inputBufferSize.toBytes());
        return httpConnectionFactory;
    }

    protected HttpConfiguration buildHttpConfiguration() {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setHeaderCacheSize((int)this.headerCacheSize.toBytes());
        httpConfig.setOutputBufferSize((int)this.outputBufferSize.toBytes());
        httpConfig.setRequestHeaderSize((int)this.maxRequestHeaderSize.toBytes());
        httpConfig.setResponseHeaderSize((int)this.maxResponseHeaderSize.toBytes());
        httpConfig.setSendDateHeader(this.useDateHeader);
        httpConfig.setSendServerVersion(this.useServerHeader);
        httpConfig.setMinResponseDataRate(this.minResponseDataPerSecond.toBytes());
        httpConfig.setMinRequestDataRate(this.minRequestDataPerSecond.toBytes());
        httpConfig.setRequestCookieCompliance(this.requestCookieCompliance);
        httpConfig.setResponseCookieCompliance(this.responseCookieCompliance);
        if (this.useForwardedHeaders) {
            httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        }
        return httpConfig;
    }

    protected ByteBufferPool buildBufferPool() {
        return new ArrayByteBufferPool((int)this.minBufferPoolSize.toBytes(), (int)this.bufferPoolIncrement.toBytes(), (int)this.maxBufferPoolSize.toBytes());
    }
}

