/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerCollection;

public class RoutingHandler
extends HandlerCollection {
    private final Entry[] entries;

    public RoutingHandler(Map<Connector, Handler> handlers) {
        this.entries = new Entry[handlers.size()];
        int i = 0;
        for (Map.Entry<Connector, Handler> entry : handlers.entrySet()) {
            this.entries[i++] = new Entry(entry.getKey(), entry.getValue());
            this.addBean(entry.getValue());
        }
        this.setHandlers(handlers.values().toArray(new Handler[0]));
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Connector connector = baseRequest.getHttpChannel().getConnector();
        for (Entry entry : this.entries) {
            if (entry.connector != connector) continue;
            entry.handler.handle(target, baseRequest, request, response);
            return;
        }
    }

    private static class Entry {
        private final Connector connector;
        private final Handler handler;

        private Entry(Connector connector, Handler handler) {
            this.connector = connector;
            this.handler = handler;
        }
    }
}

