/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.json.layout;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.dropwizard.logging.json.EventAttribute;
import io.dropwizard.logging.json.layout.AbstractJsonLayout;
import io.dropwizard.logging.json.layout.JsonFormatter;
import io.dropwizard.logging.json.layout.MapBuilder;
import io.dropwizard.logging.json.layout.TimestampFormatter;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class EventJsonLayout
extends AbstractJsonLayout<ILoggingEvent> {
    private ImmutableSet<EventAttribute> includes;
    @Nullable
    private String jsonProtocolVersion;
    private final ThrowableHandlingConverter throwableProxyConverter;
    private final TimestampFormatter timestampFormatter;
    private final Map<String, Object> additionalFields;
    private final Map<String, String> customFieldNames;
    private ImmutableSet<String> includesMdcKeys;
    private final boolean flattenMdc;

    public EventJsonLayout(JsonFormatter jsonFormatter, TimestampFormatter timestampFormatter, ThrowableHandlingConverter throwableProxyConverter, Set<EventAttribute> includes, Map<String, String> customFieldNames, Map<String, Object> additionalFields, Set<String> includesMdcKeys, boolean flattenMdc) {
        super(jsonFormatter);
        this.timestampFormatter = timestampFormatter;
        this.additionalFields = ImmutableMap.copyOf(additionalFields);
        this.customFieldNames = ImmutableMap.copyOf(customFieldNames);
        this.throwableProxyConverter = throwableProxyConverter;
        this.includes = ImmutableSet.copyOf(includes);
        this.includesMdcKeys = ImmutableSet.copyOf(includesMdcKeys);
        this.flattenMdc = flattenMdc;
    }

    public void start() {
        this.throwableProxyConverter.start();
        super.start();
    }

    public void stop() {
        super.stop();
        this.throwableProxyConverter.stop();
    }

    @Override
    protected Map<String, Object> toJsonMap(ILoggingEvent event) {
        MapBuilder mapBuilder = new MapBuilder(this.timestampFormatter, this.customFieldNames, this.additionalFields, 16).addTimestamp("timestamp", this.isIncluded(EventAttribute.TIMESTAMP), event.getTimeStamp()).add("level", this.isIncluded(EventAttribute.LEVEL), String.valueOf(event.getLevel())).add("thread", this.isIncluded(EventAttribute.THREAD_NAME), event.getThreadName()).add("logger", this.isIncluded(EventAttribute.LOGGER_NAME), event.getLoggerName()).add("marker", this.isIncluded(EventAttribute.MARKER) && event.getMarker() != null, () -> event.getMarker().getName()).add("message", this.isIncluded(EventAttribute.MESSAGE), event.getFormattedMessage()).add("context", this.isIncluded(EventAttribute.CONTEXT_NAME), event.getLoggerContextVO().getName()).add("version", this.jsonProtocolVersion != null, this.jsonProtocolVersion).add("exception", this.isIncluded(EventAttribute.EXCEPTION) && event.getThrowableProxy() != null, this.throwableProxyConverter.convert((Object)event));
        boolean includeMdc = this.isIncluded(EventAttribute.MDC);
        if (this.flattenMdc) {
            this.filterMdc(event.getMDCPropertyMap()).forEach((k, v) -> mapBuilder.add((String)k, includeMdc, (String)v));
        } else {
            mapBuilder.add("mdc", includeMdc, this.filterMdc(event.getMDCPropertyMap()));
        }
        return mapBuilder.build();
    }

    private Map<String, String> filterMdc(Map<String, String> mdcPropertyMap) {
        if (this.includesMdcKeys.isEmpty()) {
            return mdcPropertyMap;
        }
        return mdcPropertyMap.entrySet().stream().filter(e -> this.includesMdcKeys.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean isIncluded(EventAttribute include) {
        return this.includes.contains((Object)include);
    }

    public ImmutableSet<EventAttribute> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Set<EventAttribute> includes) {
        this.includes = Sets.immutableEnumSet(includes);
    }

    @Nullable
    public String getJsonProtocolVersion() {
        return this.jsonProtocolVersion;
    }

    public void setJsonProtocolVersion(@Nullable String jsonProtocolVersion) {
        this.jsonProtocolVersion = jsonProtocolVersion;
    }

    public ImmutableSet<String> getIncludesMdcKeys() {
        return this.includesMdcKeys;
    }

    public void setIncludesMdcKeys(Set<String> includesMdcKeys) {
        this.includesMdcKeys = ImmutableSet.copyOf(includesMdcKeys);
    }
}

