/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.json;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LayoutBase;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.json.AbstractJsonLayoutBaseFactory;
import io.dropwizard.logging.json.AccessAttribute;
import io.dropwizard.logging.json.layout.AccessJsonLayout;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.TimeZone;

@JsonTypeName(value="access-json")
public class AccessJsonLayoutBaseFactory
extends AbstractJsonLayoutBaseFactory<IAccessEvent> {
    private EnumSet<AccessAttribute> includes = EnumSet.of(AccessAttribute.REMOTE_ADDRESS, new AccessAttribute[]{AccessAttribute.REMOTE_USER, AccessAttribute.REQUEST_TIME, AccessAttribute.REQUEST_URI, AccessAttribute.STATUS_CODE, AccessAttribute.METHOD, AccessAttribute.PROTOCOL, AccessAttribute.CONTENT_LENGTH, AccessAttribute.USER_AGENT, AccessAttribute.TIMESTAMP});
    private Set<String> responseHeaders = Collections.emptySet();
    private Set<String> requestHeaders = Collections.emptySet();
    private Set<String> requestAttributes = Collections.emptySet();

    @JsonProperty
    public Set<String> getResponseHeaders() {
        return this.responseHeaders;
    }

    @JsonProperty
    public void setResponseHeaders(Set<String> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    @JsonProperty
    public Set<String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @JsonProperty
    public void setRequestHeaders(Set<String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    @JsonProperty
    public Set<String> getRequestAttributes() {
        return this.requestAttributes;
    }

    @JsonProperty
    public void setRequestAttributes(Set<String> requestAttributes) {
        this.requestAttributes = requestAttributes;
    }

    @JsonProperty
    public EnumSet<AccessAttribute> getIncludes() {
        return this.includes;
    }

    @JsonProperty
    public void setIncludes(EnumSet<AccessAttribute> includes) {
        this.includes = includes;
    }

    public LayoutBase<IAccessEvent> build(LoggerContext context, TimeZone timeZone) {
        AccessJsonLayout jsonLayout = new AccessJsonLayout(this.createDropwizardJsonFormatter(), this.createTimestampFormatter(timeZone), this.includes, this.getCustomFieldNames(), this.getAdditionalFields());
        jsonLayout.setContext((Context)context);
        jsonLayout.setRequestHeaders(this.requestHeaders);
        jsonLayout.setResponseHeaders(this.responseHeaders);
        jsonLayout.setRequestAttributes(this.requestAttributes);
        return jsonLayout;
    }
}

