/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.json.layout;

import io.dropwizard.logging.json.layout.TimestampFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MapBuilder {
    private final TimestampFormatter timestampFormatter;
    private final Map<String, String> customFieldNames;
    private final Map<String, Object> additionalFields;
    private final Map<String, Object> map;

    public MapBuilder(TimestampFormatter timestampFormatter, Map<String, String> customFieldNames, Map<String, Object> additionalFields, int expectedSize) {
        this.timestampFormatter = timestampFormatter;
        this.customFieldNames = Objects.requireNonNull(customFieldNames);
        this.additionalFields = Objects.requireNonNull(additionalFields);
        this.map = new LinkedHashMap<String, Object>(expectedSize);
        this.map.put(this.getFieldName("timestamp"), null);
    }

    public MapBuilder add(String fieldName, boolean include, @Nullable String value) {
        if (include && value != null) {
            this.map.put(this.getFieldName(fieldName), value);
        }
        return this;
    }

    public MapBuilder add(String fieldName, boolean include, Supplier<String> supplier) {
        String value;
        if (include && (value = supplier.get()) != null) {
            this.map.put(this.getFieldName(fieldName), value);
        }
        return this;
    }

    public MapBuilder addNumber(String fieldName, boolean include, @Nullable Number number) {
        if (include && number != null) {
            this.map.put(this.getFieldName(fieldName), number);
        }
        return this;
    }

    public MapBuilder addNumber(String fieldName, boolean include, Supplier<Number> supplier) {
        Number value;
        if (include && (value = supplier.get()) != null) {
            this.map.put(this.getFieldName(fieldName), value);
        }
        return this;
    }

    public MapBuilder add(String fieldName, boolean include, @Nullable Map<String, ?> mapValue) {
        if (include && mapValue != null && !mapValue.isEmpty()) {
            this.map.put(this.getFieldName(fieldName), mapValue);
        }
        return this;
    }

    public MapBuilder addMap(String fieldName, boolean include, Supplier<Map<String, ?>> supplier) {
        Map<String, ?> value;
        if (include && (value = supplier.get()) != null && !value.isEmpty()) {
            this.map.put(this.getFieldName(fieldName), value);
        }
        return this;
    }

    public MapBuilder addTimestamp(String fieldName, boolean include, long timestamp) {
        if (include && timestamp > 0L) {
            this.map.put(this.getFieldName(fieldName), this.timestampFormatter.format(timestamp));
        }
        return this;
    }

    private String getFieldName(String fieldName) {
        return this.customFieldNames.getOrDefault(fieldName, fieldName);
    }

    public Map<String, Object> build() {
        this.map.putAll(this.additionalFields);
        this.map.remove(this.getFieldName("timestamp"), null);
        return this.map;
    }
}

