/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.lifecycle.setup;

import com.codahale.metrics.MetricRegistry;
import io.dropwizard.lifecycle.JettyManaged;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import io.dropwizard.lifecycle.setup.ExecutorServiceBuilder;
import io.dropwizard.lifecycle.setup.ScheduledExecutorServiceBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleEnvironment.class);
    private final List<LifeCycle> managedObjects = new ArrayList<LifeCycle>();
    private final List<LifeCycle.Listener> lifecycleListeners = new ArrayList<LifeCycle.Listener>();
    private final MetricRegistry metricRegistry;

    public LifecycleEnvironment(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    public List<LifeCycle> getManagedObjects() {
        return this.managedObjects;
    }

    public void manage(Managed managed) {
        this.managedObjects.add((LifeCycle)new JettyManaged(Objects.requireNonNull(managed)));
    }

    public void manage(LifeCycle managed) {
        this.managedObjects.add(Objects.requireNonNull(managed));
    }

    public ExecutorServiceBuilder executorService(String nameFormat) {
        return new ExecutorServiceBuilder(this, nameFormat);
    }

    public ExecutorServiceBuilder executorService(String nameFormat, ThreadFactory factory) {
        return new ExecutorServiceBuilder(this, nameFormat, factory);
    }

    public ScheduledExecutorServiceBuilder scheduledExecutorService(String nameFormat) {
        return this.scheduledExecutorService(nameFormat, false);
    }

    public ScheduledExecutorServiceBuilder scheduledExecutorService(String nameFormat, ThreadFactory factory) {
        return new ScheduledExecutorServiceBuilder(this, nameFormat, factory);
    }

    public ScheduledExecutorServiceBuilder scheduledExecutorService(String nameFormat, boolean useDaemonThreads) {
        return new ScheduledExecutorServiceBuilder(this, nameFormat, useDaemonThreads);
    }

    public void addServerLifecycleListener(ServerLifecycleListener listener) {
        this.lifecycleListeners.add(new ServerListener(listener));
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
        this.lifecycleListeners.add(listener);
    }

    public void attach(ContainerLifeCycle container) {
        for (LifeCycle object : this.managedObjects) {
            container.addBean((Object)object);
        }
        container.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStarting(LifeCycle event) {
                LOGGER.debug("managed objects = {}", (Object)LifecycleEnvironment.this.managedObjects);
            }
        });
        for (LifeCycle.Listener listener : this.lifecycleListeners) {
            container.addLifeCycleListener(listener);
        }
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    private static class ServerListener
    implements LifeCycle.Listener {
        private final ServerLifecycleListener listener;

        private ServerListener(ServerLifecycleListener listener) {
            this.listener = listener;
        }

        public void lifeCycleStarted(LifeCycle event) {
            if (event instanceof Server) {
                this.listener.serverStarted((Server)event);
            }
        }
    }
}

