/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.lifecycle;

import java.util.StringJoiner;

public final class PortDescriptor {
    private static final String UNKNOWN = "UNKNOWN";
    private static final String DEFAULT_HOST = "0.0.0.0";
    private final String host;
    private final String protocol;
    private final int port;
    private final String connectorType;

    public PortDescriptor() {
        this(UNKNOWN, 0, UNKNOWN, DEFAULT_HOST);
    }

    public PortDescriptor(String protocol, int port, String connectorType, String host) {
        this.protocol = protocol;
        this.port = port;
        this.connectorType = connectorType;
        this.host = host;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public String getConnectorType() {
        return this.connectorType;
    }

    public String getHost() {
        return this.host;
    }

    public String toString() {
        return new StringJoiner(", ", PortDescriptor.class.getSimpleName() + "[", "]").add("host='" + this.host + "'").add("protocol='" + this.protocol + "'").add("port=" + this.port).add("connectorType='" + this.connectorType + "'").toString();
    }
}

