/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.recovery;

import ch.qos.logback.core.recovery.ResilientOutputStreamBase;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;

public class ResilentSocketOutputStream
extends ResilientOutputStreamBase {
    private final String host;
    private final int port;
    private final int connectionTimeoutMs;
    private final int sendBufferSize;
    private final SocketFactory socketFactory;

    public ResilentSocketOutputStream(String host, int port, int connectionTimeoutMs, int sendBufferSize, SocketFactory socketFactory) {
        this.host = host;
        this.port = port;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.sendBufferSize = sendBufferSize;
        this.socketFactory = socketFactory;
        try {
            this.os = this.openNewOutputStream();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create a TCP connection to " + host + ":" + port, e);
        }
        this.presumedClean = true;
    }

    String getDescription() {
        return "tcp [" + this.host + ":" + this.port + "]";
    }

    OutputStream openNewOutputStream() throws IOException {
        Socket socket = this.socketFactory.createSocket();
        socket.setKeepAlive(true);
        socket.connect(new InetSocketAddress(InetAddress.getByName(this.host), this.port), this.connectionTimeoutMs);
        return new BufferedOutputStream(socket.getOutputStream(), this.sendBufferSize);
    }
}

