/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.ganglia;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.ganglia.GangliaReporter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import info.ganglia.gmetric4j.gmetric.GMetric;
import io.dropwizard.metrics.BaseReporterFactory;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;

@JsonTypeName(value="ganglia")
public class GangliaReporterFactory
extends BaseReporterFactory {
    @NotNull
    @MinDuration(value=0L)
    private @MinDuration(value=0L) Duration tmax = Duration.seconds((long)1L);
    @NotNull
    @MinDuration(value=0L)
    private @MinDuration(value=0L) Duration dmax = Duration.seconds((long)0L);
    @NotEmpty
    private String host = "localhost";
    @Range(min=1L, max=49151L)
    private int port = 8649;
    @NotNull
    private GMetric.UDPAddressingMode mode = GMetric.UDPAddressingMode.UNICAST;
    @Range(min=0L, max=255L)
    private int ttl = 1;
    private String prefix;
    private UUID uuid;
    private String spoof;

    @JsonProperty
    public Duration getTmax() {
        return this.tmax;
    }

    @JsonProperty
    public void setTmax(Duration tmax) {
        this.tmax = tmax;
    }

    @JsonProperty
    public Duration getDmax() {
        return this.dmax;
    }

    @JsonProperty
    public void setDmax(Duration dmax) {
        this.dmax = dmax;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(int port) {
        this.port = port;
    }

    @JsonProperty
    public GMetric.UDPAddressingMode getMode() {
        return this.mode;
    }

    @JsonProperty
    public void setMode(GMetric.UDPAddressingMode mode) {
        this.mode = mode;
    }

    @JsonProperty
    public int getTtl() {
        return this.ttl;
    }

    @JsonProperty
    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @JsonProperty
    public Optional<UUID> getUuid() {
        return Optional.ofNullable(this.uuid);
    }

    @JsonProperty
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @JsonProperty
    public Optional<String> getSpoof() {
        return Optional.ofNullable(this.spoof);
    }

    @JsonProperty
    public void setSpoof(String spoof) {
        this.spoof = spoof;
    }

    public ScheduledReporter build(MetricRegistry registry) {
        try {
            GMetric ganglia = new GMetric(this.host, this.port, this.mode, this.ttl, this.uuid != null || this.spoof != null, this.uuid, this.spoof);
            return GangliaReporter.forRegistry((MetricRegistry)registry).convertDurationsTo(this.getDurationUnit()).convertRatesTo(this.getRateUnit()).filter(this.getFilter()).prefixedWith(this.getPrefix()).withDMax((int)this.dmax.toSeconds()).withTMax((int)this.tmax.toSeconds()).build(ganglia);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

