/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.graphite;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.graphite.GraphiteUDP;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.metrics.BaseReporterFactory;
import io.dropwizard.validation.OneOf;
import io.dropwizard.validation.PortRange;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="graphite")
public class GraphiteReporterFactory
extends BaseReporterFactory {
    @NotEmpty
    private String host = "localhost";
    @PortRange
    private int port = 2003;
    @NotNull
    private String prefix = "";
    @NotNull
    @OneOf(value={"tcp", "udp"}, ignoreCase=true)
    private @NotNull @OneOf(value={"tcp", "udp"}, ignoreCase=true) String transport = "tcp";

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(int port) {
        this.port = port;
    }

    @JsonProperty
    public String getPrefix() {
        return this.prefix;
    }

    @JsonProperty
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @JsonProperty
    public String getTransport() {
        return this.transport;
    }

    @JsonProperty
    public void setTransport(String transport) {
        this.transport = transport;
    }

    public ScheduledReporter build(MetricRegistry registry) {
        GraphiteReporter.Builder builder = this.builder(registry);
        if ("udp".equalsIgnoreCase(this.transport)) {
            return builder.build((GraphiteSender)new GraphiteUDP(this.host, this.port));
        }
        return builder.build(new Graphite(this.host, this.port));
    }

    protected GraphiteReporter.Builder builder(MetricRegistry registry) {
        return GraphiteReporter.forRegistry((MetricRegistry)registry).convertDurationsTo(this.getDurationUnit()).convertRatesTo(this.getRateUnit()).filter(this.getFilter()).prefixedWith(this.getPrefix()).disabledMetricAttributes(this.getDisabledAttributes());
    }
}

