/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import io.dropwizard.metrics.ReporterFactory;
import io.dropwizard.util.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

public abstract class BaseReporterFactory
implements ReporterFactory {
    @NotNull
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    @NotNull
    private TimeUnit rateUnit = TimeUnit.SECONDS;
    @NotNull
    private ImmutableSet<String> excludes = ImmutableSet.of();
    @NotNull
    private ImmutableSet<String> includes = ImmutableSet.of();
    @NotNull
    @Valid
    private Optional<Duration> frequency = Optional.of((Object)Duration.seconds((long)1L));

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    @JsonProperty
    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    @JsonProperty
    public TimeUnit getRateUnit() {
        return this.rateUnit;
    }

    @JsonProperty
    public void setRateUnit(TimeUnit rateUnit) {
        this.rateUnit = rateUnit;
    }

    @JsonProperty
    public ImmutableSet<String> getIncludes() {
        return this.includes;
    }

    @JsonProperty
    public void setIncludes(ImmutableSet<String> includes) {
        this.includes = includes;
    }

    @JsonProperty
    public ImmutableSet<String> getExcludes() {
        return this.excludes;
    }

    @JsonProperty
    public void setExcludes(ImmutableSet<String> excludes) {
        this.excludes = excludes;
    }

    @Override
    @JsonProperty
    public Optional<Duration> getFrequency() {
        return this.frequency;
    }

    @JsonProperty
    public void setFrequency(Optional<Duration> frequency) {
        this.frequency = frequency;
    }

    public MetricFilter getFilter() {
        return new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                return !BaseReporterFactory.this.getIncludes().isEmpty() && BaseReporterFactory.this.getIncludes().contains((Object)name) || !BaseReporterFactory.this.getExcludes().contains((Object)name);
            }
        };
    }
}

