/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.metrics.BaseFormattedReporterFactory;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonTypeName(value="csv")
public class CsvReporterFactory
extends BaseFormattedReporterFactory {
    @Nullable
    private File file;

    @JsonProperty
    @Nullable
    public File getFile() {
        return this.file;
    }

    @JsonProperty
    public void setFile(@Nullable File file) {
        this.file = file;
    }

    @Override
    public ScheduledReporter build(MetricRegistry registry) {
        File directory = Objects.requireNonNull(this.getFile(), "File is not set");
        boolean creation = directory.mkdirs();
        if (!creation && !directory.exists()) {
            throw new RuntimeException("Failed to create" + directory.getAbsolutePath());
        }
        return CsvReporter.forRegistry((MetricRegistry)registry).convertDurationsTo(this.getDurationUnit()).convertRatesTo(this.getRateUnit()).filter(this.getFilter()).formatFor(this.getLocale()).build(directory);
    }
}

