/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import com.google.common.base.Charsets;
import io.dropwizard.Configuration;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.migrations.AbstractLiquibaseCommand;
import java.io.PrintStream;
import java.util.HashSet;
import liquibase.Liquibase;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.structure.core.Column;
import liquibase.structure.core.Data;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Sequence;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import liquibase.structure.core.View;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbDumpCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    public DbDumpCommand(DatabaseConfiguration<T> strategy, Class<T> configurationClass) {
        super("dump", "Generate a dump of the existing database state.", strategy, configurationClass);
    }

    @Override
    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"-o", "--output"}).dest("output").help("Write output to <file> instead of stdout");
        ArgumentGroup tables = subparser.addArgumentGroup("Tables");
        tables.addArgument(new String[]{"--tables"}).action((ArgumentAction)Arguments.storeTrue()).dest("tables").help("Check for added or removed tables (default)");
        tables.addArgument(new String[]{"--ignore-tables"}).action((ArgumentAction)Arguments.storeFalse()).dest("tables").help("Ignore tables");
        ArgumentGroup columns = subparser.addArgumentGroup("Columns");
        columns.addArgument(new String[]{"--columns"}).action((ArgumentAction)Arguments.storeTrue()).dest("columns").help("Check for added, removed, or modified tables (default)");
        columns.addArgument(new String[]{"--ignore-columns"}).action((ArgumentAction)Arguments.storeFalse()).dest("columns").help("Ignore columns");
        ArgumentGroup views = subparser.addArgumentGroup("Views");
        views.addArgument(new String[]{"--views"}).action((ArgumentAction)Arguments.storeTrue()).dest("views").help("Check for added, removed, or modified views (default)");
        views.addArgument(new String[]{"--ignore-views"}).action((ArgumentAction)Arguments.storeFalse()).dest("views").help("Ignore views");
        ArgumentGroup primaryKeys = subparser.addArgumentGroup("Primary Keys");
        primaryKeys.addArgument(new String[]{"--primary-keys"}).action((ArgumentAction)Arguments.storeTrue()).dest("primary-keys").help("Check for changed primary keys (default)");
        primaryKeys.addArgument(new String[]{"--ignore-primary-keys"}).action((ArgumentAction)Arguments.storeFalse()).dest("primary-keys").help("Ignore primary keys");
        ArgumentGroup uniqueConstraints = subparser.addArgumentGroup("Unique Constraints");
        uniqueConstraints.addArgument(new String[]{"--unique-constraints"}).action((ArgumentAction)Arguments.storeTrue()).dest("unique-constraints").help("Check for changed unique constraints (default)");
        uniqueConstraints.addArgument(new String[]{"--ignore-unique-constraints"}).action((ArgumentAction)Arguments.storeFalse()).dest("unique-constraints").help("Ignore unique constraints");
        ArgumentGroup indexes = subparser.addArgumentGroup("Indexes");
        indexes.addArgument(new String[]{"--indexes"}).action((ArgumentAction)Arguments.storeTrue()).dest("indexes").help("Check for changed indexes (default)");
        indexes.addArgument(new String[]{"--ignore-indexes"}).action((ArgumentAction)Arguments.storeFalse()).dest("indexes").help("Ignore indexes");
        ArgumentGroup foreignKeys = subparser.addArgumentGroup("Foreign Keys");
        foreignKeys.addArgument(new String[]{"--foreign-keys"}).action((ArgumentAction)Arguments.storeTrue()).dest("foreign-keys").help("Check for changed foreign keys (default)");
        foreignKeys.addArgument(new String[]{"--ignore-foreign-keys"}).action((ArgumentAction)Arguments.storeFalse()).dest("foreign-keys").help("Ignore foreign keys");
        ArgumentGroup sequences = subparser.addArgumentGroup("Sequences");
        sequences.addArgument(new String[]{"--sequences"}).action((ArgumentAction)Arguments.storeTrue()).dest("sequences").help("Check for changed sequences (default)");
        sequences.addArgument(new String[]{"--ignore-sequences"}).action((ArgumentAction)Arguments.storeFalse()).dest("sequences").help("Ignore foreign keys");
        ArgumentGroup data = subparser.addArgumentGroup("Data");
        data.addArgument(new String[]{"--data"}).action((ArgumentAction)Arguments.storeTrue()).dest("data").help("Check for changed data").setDefault((Object)Boolean.FALSE);
        data.addArgument(new String[]{"--ignore-data"}).action((ArgumentAction)Arguments.storeFalse()).dest("data").help("Ignore data (default)").setDefault((Object)Boolean.FALSE);
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        HashSet<Class<View>> compareTypes = new HashSet<Class<View>>();
        if (namespace.getBoolean("columns").booleanValue()) {
            compareTypes.add(Column.class);
        }
        if (namespace.getBoolean("data").booleanValue()) {
            compareTypes.add(Data.class);
        }
        if (namespace.getBoolean("foreign-keys").booleanValue()) {
            compareTypes.add(ForeignKey.class);
        }
        if (namespace.getBoolean("indexes").booleanValue()) {
            compareTypes.add(Index.class);
        }
        if (namespace.getBoolean("primary-keys").booleanValue()) {
            compareTypes.add(PrimaryKey.class);
        }
        if (namespace.getBoolean("sequences").booleanValue()) {
            compareTypes.add(Sequence.class);
        }
        if (namespace.getBoolean("tables").booleanValue()) {
            compareTypes.add(Table.class);
        }
        if (namespace.getBoolean("unique-constraints").booleanValue()) {
            compareTypes.add(UniqueConstraint.class);
        }
        if (namespace.getBoolean("views").booleanValue()) {
            compareTypes.add(View.class);
        }
        DiffResult diffResult = DiffGeneratorFactory.getInstance().compare(liquibase.getDatabase(), null, new CompareControl(compareTypes));
        DiffToChangeLog diffToChangeLog = new DiffToChangeLog(diffResult, new DiffOutputControl());
        String filename = namespace.getString("output");
        if (filename != null) {
            try (PrintStream file = new PrintStream(filename, Charsets.UTF_8.name());){
                diffToChangeLog.print(file);
            }
        } else {
            diffToChangeLog.print(System.out);
        }
    }
}

