/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import io.dropwizard.db.ManagedDataSource;
import java.sql.SQLException;
import liquibase.Liquibase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;

public class CloseableLiquibase
extends Liquibase
implements AutoCloseable {
    private static final String DEFAULT_MIGRATIONS_FILE = "migrations.xml";
    private final ManagedDataSource dataSource;

    public CloseableLiquibase(ManagedDataSource dataSource) throws LiquibaseException, ClassNotFoundException, SQLException {
        super(DEFAULT_MIGRATIONS_FILE, (ResourceAccessor)new ClassLoaderResourceAccessor(), (DatabaseConnection)new JdbcConnection(dataSource.getConnection()));
        this.dataSource = dataSource;
    }

    public CloseableLiquibase(ManagedDataSource dataSource, String file) throws LiquibaseException, ClassNotFoundException, SQLException {
        super(file, (ResourceAccessor)new FileSystemResourceAccessor(), (DatabaseConnection)new JdbcConnection(dataSource.getConnection()));
        this.dataSource = dataSource;
    }

    @Override
    public void close() throws Exception {
        this.dataSource.stop();
    }
}

