/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import io.dropwizard.Configuration;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.migrations.AbstractLiquibaseCommand;
import liquibase.Liquibase;
import liquibase.change.CheckSum;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCalculateChecksumCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"liquibase");

    public DbCalculateChecksumCommand(DatabaseConfiguration<T> strategy, Class<T> configurationClass) {
        super("calculate-checksum", "Calculates and prints a checksum for a change set", strategy, configurationClass);
    }

    @Override
    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"id"}).nargs(1).help("change set id");
        subparser.addArgument(new String[]{"author"}).nargs(1).help("author name");
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        CheckSum checkSum = liquibase.calculateCheckSum("migrations.xml", (String)namespace.getList("id").get(0), (String)namespace.getList("author").get(0));
        LOGGER.info("checksum = {}", (Object)checkSum);
    }
}

