/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.migrations.CloseableLiquibase;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.ResourceAccessor;

public class CloseableLiquibaseWithFileSystemMigrationsFile
extends CloseableLiquibase
implements AutoCloseable {
    CloseableLiquibaseWithFileSystemMigrationsFile(ManagedDataSource dataSource, Database database, String file) throws LiquibaseException, SQLException {
        this(dataSource, database, file, FileSystems.getDefault());
    }

    CloseableLiquibaseWithFileSystemMigrationsFile(ManagedDataSource dataSource, Database database, String file, FileSystem fileSystem) throws LiquibaseException, SQLException {
        super(file, (ResourceAccessor)new CompositeResourceAccessor(CloseableLiquibaseWithFileSystemMigrationsFile.directoryResourceAccessors(fileSystem)), database, dataSource);
    }

    private static Collection<ResourceAccessor> directoryResourceAccessors(FileSystem fileSystem) {
        return StreamSupport.stream(fileSystem.getRootDirectories().spliterator(), false).map(path -> {
            try {
                return new DirectoryResourceAccessor(path);
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public CloseableLiquibaseWithFileSystemMigrationsFile(ManagedDataSource dataSource, String file) throws LiquibaseException, SQLException {
        this(dataSource, DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(dataSource.getConnection())), file);
    }
}

