/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import com.codahale.metrics.MetricRegistry;
import io.dropwizard.core.Configuration;
import io.dropwizard.core.cli.ConfiguredCommand;
import io.dropwizard.core.setup.Bootstrap;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.db.ManagedDataSource;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.migrations.CloseableLiquibase;
import io.dropwizard.migrations.CloseableLiquibaseWithClassPathMigrationsFile;
import io.dropwizard.migrations.CloseableLiquibaseWithFileSystemMigrationsFile;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractLiquibaseCommand<T extends Configuration>
extends ConfiguredCommand<T> {
    private final DatabaseConfiguration<T> strategy;
    private final Class<T> configurationClass;
    private final String migrationsFileName;

    protected AbstractLiquibaseCommand(String name, String description, DatabaseConfiguration<T> strategy, Class<T> configurationClass, String migrationsFileName) {
        super(name, description);
        this.strategy = strategy;
        this.configurationClass = configurationClass;
        this.migrationsFileName = migrationsFileName;
    }

    protected Class<T> getConfigurationClass() {
        return this.configurationClass;
    }

    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"--migrations"}).dest("migrations-file").help("the file containing the Liquibase migrations for the application");
        subparser.addArgument(new String[]{"--catalog"}).dest("catalog").help("Specify the database catalog (use database default if omitted)");
        subparser.addArgument(new String[]{"--schema"}).dest("schema").help("Specify the database schema (use database default if omitted)");
        subparser.addArgument(new String[]{"--analytics-enabled"}).setDefault((Object)false).dest("analytics-enabled").help("This turns on analytics gathering for that single occurrence of a command.");
    }

    protected void run(@Nullable Bootstrap<T> bootstrap, Namespace namespace, T configuration) throws Exception {
        PooledDataSourceFactory dbConfig = this.strategy.getDataSourceFactory(configuration);
        dbConfig.asSingleConnectionPool();
        try (CloseableLiquibase liquibase = this.openLiquibase(dbConfig, namespace);){
            this.run(namespace, liquibase);
        }
        catch (ValidationFailedException e) {
            e.printDescriptiveError(System.err);
            throw e;
        }
    }

    CloseableLiquibase openLiquibase(PooledDataSourceFactory dataSourceFactory, Namespace namespace) throws SQLException, LiquibaseException {
        ManagedDataSource dataSource = dataSourceFactory.build(new MetricRegistry(), "liquibase");
        Database database = this.createDatabase(dataSource, namespace);
        String migrationsFile = namespace.getString("migrations-file");
        CloseableLiquibase liquibase = migrationsFile == null ? new CloseableLiquibaseWithClassPathMigrationsFile(dataSource, database, this.migrationsFileName) : new CloseableLiquibaseWithFileSystemMigrationsFile(dataSource, database, migrationsFile);
        Boolean analyticsEnabled = namespace.getBoolean("analytics-enabled");
        try {
            Map<String, Level> values = Map.of("liquibase.analytics.enabled", analyticsEnabled != null && analyticsEnabled != false, "liquibase.analytics.logLevel", Level.FINEST);
            Scope.enter(values);
        }
        catch (Exception e) {
            throw new LiquibaseException((Throwable)e);
        }
        return liquibase;
    }

    private Database createDatabase(ManagedDataSource dataSource, Namespace namespace) throws SQLException, LiquibaseException {
        JdbcConnection conn = new JdbcConnection(dataSource.getConnection());
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)conn);
        String catalogName = namespace.getString("catalog");
        String schemaName = namespace.getString("schema");
        if (database.supports(Catalog.class) && catalogName != null) {
            database.setDefaultCatalogName(catalogName);
            database.setOutputDefaultCatalog(true);
        }
        if (database.supports(Schema.class) && schemaName != null) {
            database.setDefaultSchemaName(schemaName);
            database.setOutputDefaultSchema(true);
        }
        return database;
    }

    protected abstract void run(Namespace var1, Liquibase var2) throws Exception;
}

