/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.request.logging.old;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import java.io.IOException;
import java.util.TimeZone;
import org.eclipse.jetty.server.AbstractNCSARequestLog;

public class DropwizardSlf4jRequestLog
extends AbstractNCSARequestLog {
    private final AppenderAttachableImpl<ILoggingEvent> appenders;

    DropwizardSlf4jRequestLog(AppenderAttachableImpl<ILoggingEvent> appenders, TimeZone timeZone) {
        this.appenders = appenders;
        this.setLogLatency(true);
        this.setLogTimeZone(timeZone);
        this.setExtended(true);
        this.setPreferProxiedForAddress(true);
        try {
            this.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Should have succeeded doing a noop start", e);
        }
    }

    protected boolean isEnabled() {
        return true;
    }

    public void write(String entry) throws IOException {
        LoggingEvent event = new LoggingEvent();
        event.setLevel(Level.INFO);
        event.setLoggerName("http.request");
        event.setMessage(entry);
        event.setTimeStamp(System.currentTimeMillis());
        this.appenders.appendLoopOnAppenders((Object)event);
    }

    void setLogTimeZone(TimeZone tz) {
        this.setLogTimeZone(tz.getID());
    }

    protected void doStop() throws Exception {
        this.appenders.detachAndStopAllAppenders();
        super.doStop();
    }
}

