/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.request.logging;

import ch.qos.logback.access.jetty.RequestLogImpl;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.FilterReply;
import io.dropwizard.request.logging.DropwizardJettyServerAdapter;
import java.util.EventListener;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.LifeCycle;

public class LogbackAccessRequestLog
extends RequestLogImpl
implements LifeCycle {
    public void configure() {
        this.setName("LogbackAccessRequestLog");
    }

    public void log(Request jettyRequest, Response jettyResponse) {
        DropwizardJettyServerAdapter adapter = new DropwizardJettyServerAdapter(jettyRequest, jettyResponse);
        AccessEvent accessEvent = new AccessEvent((Context)this, (HttpServletRequest)jettyRequest, (HttpServletResponse)jettyResponse, (ServerAdapter)adapter);
        if (this.getFilterChainDecision((IAccessEvent)accessEvent) == FilterReply.DENY) {
            return;
        }
        this.appendLoopOnAppenders((IAccessEvent)accessEvent);
    }

    private void appendLoopOnAppenders(IAccessEvent iAccessEvent) {
        Iterator appenderIterator = this.iteratorForAppenders();
        while (appenderIterator.hasNext()) {
            ((Appender)appenderIterator.next()).doAppend((Object)iAccessEvent);
        }
    }

    public boolean addEventListener(EventListener eventListener) {
        if (eventListener instanceof LifeCycle.Listener) {
            this.addLifeCycleListener((LifeCycle.Listener)eventListener);
            return true;
        }
        return false;
    }

    public boolean removeEventListener(EventListener eventListener) {
        if (eventListener instanceof LifeCycle.Listener) {
            this.removeLifeCycleListener((LifeCycle.Listener)eventListener);
            return true;
        }
        return false;
    }
}

