/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.request.logging;

import ch.qos.logback.access.spi.ServerAdapter;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

class DropwizardJettyServerAdapter
implements ServerAdapter {
    private final Request request;
    private final Response response;

    public DropwizardJettyServerAdapter(Request request, Response response) {
        this.request = request;
        this.response = response;
    }

    public long getRequestTimestamp() {
        return Request.getTimeStamp((Request)this.request);
    }

    public long getContentLength() {
        return Response.getContentBytesWritten((Response)this.response);
    }

    public int getStatusCode() {
        return this.response.getStatus();
    }

    public Map<String, String> buildResponseHeaderMap() {
        return this.response.getHeaders().stream().collect(Collectors.groupingBy(HttpField::getName, Collectors.mapping(HttpField::getValue, Collectors.joining(","))));
    }
}

