/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.request.logging;

import ch.qos.logback.access.common.spi.AccessEvent;
import ch.qos.logback.access.common.spi.IAccessEvent;
import ch.qos.logback.access.common.spi.ServerAdapter;
import ch.qos.logback.access.jetty.RequestLogImpl;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.FilterReply;
import io.dropwizard.request.logging.DropwizardJettyServerAdapter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Iterator;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletApiResponse;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class LogbackAccessRequestLog
extends RequestLogImpl {
    public void configure() {
        this.setName("LogbackAccessRequestLog");
    }

    public void log(Request jettyRequest, Response jettyResponse) {
        DropwizardJettyServerAdapter adapter = new DropwizardJettyServerAdapter(jettyRequest, jettyResponse);
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)jettyRequest, ServletContextRequest.class);
        if (servletContextRequest == null) {
            throw new IllegalStateException("Expecting request to be an instance of ServletContextRequest");
        }
        DropwizardServletApiRequest httpServletRequest = new DropwizardServletApiRequest(servletContextRequest);
        DropwizardServletApiResponse httpServletResponse = new DropwizardServletApiResponse(servletContextRequest.getServletContextResponse());
        AccessEvent accessEvent = new AccessEvent((Context)this, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (ServerAdapter)adapter);
        if (this.getFilterChainDecision((IAccessEvent)accessEvent) == FilterReply.DENY) {
            return;
        }
        this.appendLoopOnAppenders((IAccessEvent)accessEvent);
    }

    private void appendLoopOnAppenders(IAccessEvent iAccessEvent) {
        Iterator appenderIterator = this.iteratorForAppenders();
        while (appenderIterator.hasNext()) {
            ((Appender)appenderIterator.next()).doAppend((Object)iAccessEvent);
        }
    }

    private static class DropwizardServletApiRequest
    extends ServletApiRequest {
        private final ServletContextRequest servletContextRequest;

        public DropwizardServletApiRequest(ServletContextRequest servletContextRequest) {
            super(servletContextRequest);
            this.servletContextRequest = servletContextRequest;
        }

        public Request getRequest() {
            return this.servletContextRequest;
        }
    }

    private static class DropwizardServletApiResponse
    extends ServletApiResponse {
        private final ServletContextResponse servletContextResponse;

        public DropwizardServletApiResponse(ServletContextResponse servletContextResponse) {
            super(servletContextResponse);
            this.servletContextResponse = servletContextResponse;
        }

        public Response getResponse() {
            return this.servletContextResponse;
        }
    }
}

