/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing.junit;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.jersey.DropwizardResourceConfig;
import io.dropwizard.jersey.jackson.JacksonMessageBodyProvider;
import io.dropwizard.logging.LoggingFactory;
import java.util.Map;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.test.JerseyTest;
import org.glassfish.jersey.test.inmemory.InMemoryTestContainerFactory;
import org.glassfish.jersey.test.spi.TestContainerException;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ResourceTestRule
implements TestRule {
    private final Set<Object> singletons;
    private final Set<Class<?>> providers;
    private final Map<String, Object> properties;
    private final ObjectMapper mapper;
    private final Validator validator;
    private final TestContainerFactory testContainerFactory;
    private JerseyTest test;

    public static Builder builder() {
        return new Builder();
    }

    private ResourceTestRule(Set<Object> singletons, Set<Class<?>> providers, Map<String, Object> properties, ObjectMapper mapper, Validator validator, TestContainerFactory testContainerFactory) {
        this.singletons = singletons;
        this.providers = providers;
        this.properties = properties;
        this.mapper = mapper;
        this.validator = validator;
        this.testContainerFactory = testContainerFactory;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public Client client() {
        return this.test.client();
    }

    public JerseyTest getJerseyTest() {
        return this.test;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    ResourceTestRule.this.test = new JerseyTest(){

                        protected Application configure() {
                            DropwizardResourceConfig config = DropwizardResourceConfig.forTesting((MetricRegistry)new MetricRegistry());
                            for (Class clazz : ResourceTestRule.this.providers) {
                                config.register(clazz);
                            }
                            for (Map.Entry entry : ResourceTestRule.this.properties.entrySet()) {
                                config.property((String)entry.getKey(), entry.getValue());
                            }
                            config.register((Object)new JacksonMessageBodyProvider(ResourceTestRule.this.mapper, ResourceTestRule.this.validator));
                            for (Object object : ResourceTestRule.this.singletons) {
                                config.register(object);
                            }
                            return config;
                        }

                        protected TestContainerFactory getTestContainerFactory() throws TestContainerException {
                            return ResourceTestRule.this.testContainerFactory;
                        }
                    };
                    ResourceTestRule.this.test.setUp();
                    base.evaluate();
                }
                finally {
                    if (ResourceTestRule.this.test != null) {
                        ResourceTestRule.this.test.tearDown();
                    }
                }
            }
        };
    }

    static {
        LoggingFactory.bootstrap();
    }

    public static class Builder {
        private final Set<Object> singletons = Sets.newHashSet();
        private final Set<Class<?>> providers = Sets.newHashSet();
        private final Map<String, Object> properties = Maps.newHashMap();
        private ObjectMapper mapper = Jackson.newObjectMapper();
        private Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
        private TestContainerFactory testContainerFactory = new InMemoryTestContainerFactory();

        public Builder setMapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder setValidator(Validator validator) {
            this.validator = validator;
            return this;
        }

        public Builder addResource(Object resource) {
            this.singletons.add(resource);
            return this;
        }

        public Builder addProvider(Class<?> klass) {
            this.providers.add(klass);
            return this;
        }

        public Builder addProvider(Object provider) {
            this.singletons.add(provider);
            return this;
        }

        public Builder addProperty(String property, Object value) {
            this.properties.put(property, value);
            return this;
        }

        public Builder setTestContainerFactory(TestContainerFactory factory) {
            this.testContainerFactory = factory;
            return this;
        }

        public ResourceTestRule build() {
            return new ResourceTestRule(this.singletons, this.providers, this.properties, this.mapper, this.validator, this.testContainerFactory);
        }
    }
}

